/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.cleaner;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.cleaner.BaseCleaner;
import kd.bos.workflow.engine.impl.clean.cleaner.ProcessCleaner;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;
import kd.bos.workflow.engine.impl.clean.model.RelaCleanConfigParam;
import kd.bos.workflow.engine.impl.clean.transfer.EntityTransferFactory;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class DefaultProcessCleaner
extends BaseCleaner
implements ProcessCleaner {
    private static Log log = LogFactory.getLog(DefaultProcessCleaner.class);

    @Override
    public void execute(CommandContext commandContext, CleanTaskConfigParam configParam, List<String> businessKeys, List<Long> procInstIds) {
        if (WfUtils.isEmpty(configParam.getMainEntityNumber())) {
            log.debug(String.format("\u6309\u6d41\u7a0b\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u6267\u884c\u6e05\u7406\u5931\u8d25\uff0cmainEntityNumber \u4e3a\u7a7a\uff01", configParam.getMainEntityNumber()));
            return;
        }
        this.cleanProcData(configParam, businessKeys, procInstIds);
    }

    private void cleanProcData(CleanTaskConfigParam configParam, List<String> businessKeys, List<Long> procInstIds) {
        String cleanIndex = configParam.getCleanIndex();
        String cleanIndexFeild = this.getCleanIndexFeild(configParam.getMainEntityNumber(), cleanIndex);
        List<Object> cleanParam = this.getCleanParam(cleanIndex, businessKeys, procInstIds);
        log.debug(String.format("\u6309\u6d41\u7a0b\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u5f00\u59cb\u6267\u884c\u6e05\u7406\uff01\u6e05\u7406\u65f6\u673a[%s]\uff0c\u6e05\u7406\u7d22\u5f15[%s]", configParam.getMainEntityNumber(), configParam.getCleanMoment(), cleanIndex));
        ArrayList<Object> partParams = new ArrayList<Object>(1000);
        if (WfUtils.isEmptyForCollection(cleanParam)) {
            log.debug(String.format("\u6309\u6d41\u7a0b\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u6267\u884c\u6e05\u7406\u5931\u8d25\uff01\u6e05\u7406\u65f6\u673a[%s]\uff0c\u6e05\u7406\u7d22\u5f15[%s]\uff0c\u6e05\u7406\u7d22\u5f15\u5bf9\u5e94\u53c2\u6570\u4e3a\u7a7a\uff01", configParam.getMainEntityNumber(), configParam.getCleanMoment(), cleanIndex));
            return;
        }
        if (cleanParam == null) {
            return;
        }
        for (int i = 0; i < cleanParam.size(); ++i) {
            partParams.add(cleanParam.get(i));
            if ((i + 1) % 1000 != 0) continue;
            this.cleanPartDatas(configParam, cleanIndexFeild, partParams);
            partParams.clear();
        }
        if (WfUtils.isNotEmptyForCollection(partParams)) {
            this.cleanPartDatas(configParam, cleanIndexFeild, partParams);
        }
        log.debug(String.format("\u6309\u6d41\u7a0b\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u6267\u884c\u6e05\u7406\u5b8c\u6210\uff01", configParam.getMainEntityNumber()));
    }

    private void cleanPartDatas(CleanTaskConfigParam configParam, String cleanIndexFeild, List<Object> partParams) {
        List<Object> pks;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter(cleanIndexFeild, "in", partParams));
        if (configParam.getConditionFilters() != null) {
            filters.add(configParam.getConditionFilters());
        }
        if (WfUtils.isEmptyForCollection(pks = this.findPkValues(configParam.getMainEntityNumber(), filters))) {
            return;
        }
        if (configParam.getRelaCleanConfigParams() != null) {
            for (RelaCleanConfigParam relaParam : configParam.getRelaCleanConfigParams()) {
                this.disposeRelaEntityData(pks, relaParam, configParam.getDisposalType());
            }
        }
        String pkFeild = EntityMetadataCache.getDataEntityType((String)configParam.getMainEntityNumber()).getPrimaryKey().getName();
        this.disposeMainEntityData(pkFeild, pks, configParam);
    }

    private List<Object> findPkValues(String entityNumber, List<QFilter> filters) {
        String pkFeild = EntityMetadataCache.getDataEntityType((String)entityNumber).getPrimaryKey().getName();
        ArrayList<Object> pks = new ArrayList<Object>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AbstractTimeCleaner", (String)entityNumber, (String)pkFeild, (QFilter[])filters.toArray(new QFilter[0]), null);){
            while (dataSet != null && dataSet.hasNext()) {
                Row row = dataSet.next();
                pks.add(row.get(pkFeild));
            }
        }
        return pks;
    }

    private List<Object> getCleanParam(String cleanIndex, List<String> businessKeys, List<Long> procInstIds) {
        ArrayList<Object> params = null;
        switch (cleanIndex) {
            case "businessKey": {
                if (!WfUtils.isNotEmptyForCollection(businessKeys)) break;
                params = new ArrayList<Object>(businessKeys.size());
                params.addAll(businessKeys);
                break;
            }
            case "processInstanceId": {
                if (!WfUtils.isNotEmptyForCollection(procInstIds)) break;
                params = new ArrayList(procInstIds.size());
                params.addAll(procInstIds);
                break;
            }
        }
        return params;
    }

    protected String getCleanIndexFeild(String entityNumber, String cleanIndex) {
        return EntityTransferFactory.createEntityTransfer("wf_historicalprocesses", entityNumber).getTargetProperty(cleanIndex.toLowerCase().trim());
    }
}

