/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.cleaner;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.cleaner.BaseCleaner;
import kd.bos.workflow.engine.impl.clean.cleaner.RegularTimeCleaner;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;
import kd.bos.workflow.engine.impl.clean.model.RelaCleanConfigParam;

public class DefaultRegularTimeCleaner
extends BaseCleaner
implements RegularTimeCleaner {
    private static Log log = LogFactory.getLog(DefaultRegularTimeCleaner.class);
    public static final String VALUE_STARTINGTIME = "startingTime";
    public static final String VALUE_SEEKDATE = "seekDate";
    public static final String VALUE_STARTINGDATE = "startingDate";
    private static final int DEFAULT_STEPLIMITQUANTITY = 50000;
    private static final int DEFAULT_LIMITQUANTITY = 5000000;

    @Override
    public Map<String, Object> execute(CleanTaskConfigParam configParam) {
        Map<String, Object> parameters = configParam.getParams();
        if (parameters == null) {
            parameters = new HashMap<String, Object>(3);
            configParam.setParams(parameters);
        }
        if (!this.validateParam(configParam)) {
            return configParam.getParams();
        }
        int retentionTime = configParam.getRetentionTime() == 0 ? 15 : configParam.getRetentionTime();
        log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u5f00\u59cb\u6267\u884c\u6e05\u7406\uff01\u4fdd\u7559\u65f6\u95f4[%s]", configParam.getMainEntityNumber(), retentionTime));
        Date maxCleanDate = this.getTargetTime(WfUtils.now(), -retentionTime);
        if (maxCleanDate == null) {
            log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u5f00\u59cb\u6267\u884c\u6e05\u7406\uff01maxCleanDate \u4e3a\u7a7a", configParam.getMainEntityNumber()));
            return configParam.getParams();
        }
        Date seekDate = null;
        seekDate = parameters.get(VALUE_STARTINGTIME) != null ? new Date((Long)parameters.get(VALUE_STARTINGTIME)) : this.getRealStartingDate(configParam, maxCleanDate);
        if (seekDate == null) {
            log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u5f00\u59cb\u6267\u884c\u6e05\u7406\uff01startingDate \u4e3a\u7a7a", configParam.getMainEntityNumber()));
            return configParam.getParams();
        }
        configParam.getParams().put(VALUE_STARTINGDATE, seekDate);
        this.findAndCleanData(configParam, seekDate, maxCleanDate);
        this.updateStartingDate(configParam);
        log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u6267\u884c\u6e05\u7406\u5b8c\u6210\uff01", configParam.getMainEntityNumber()));
        return configParam.getParams();
    }

    protected void findAndCleanData(CleanTaskConfigParam configParam, Date seekDate, Date maxCleanDate) {
        int limitQuantity = configParam.getLimitQuantity() == 0 ? this.getDefaultLimitQuantity() : configParam.getLimitQuantity();
        int stepLimitQuantity = configParam.getStepLimitQuantity() == 0 || configParam.getStepLimitQuantity() > this.getDefaultStepLimitQuantity() ? this.getDefaultStepLimitQuantity() : configParam.getStepLimitQuantity();
        int cleanCount = 0;
        int loopCount = 0;
        do {
            int disposeTotal = this.executeEverySegment(configParam, stepLimitQuantity, seekDate, maxCleanDate);
            seekDate = this.getNextSeekDate(configParam);
            cleanCount = disposeTotal + cleanCount;
        } while (!seekDate.equals(maxCleanDate) && !seekDate.after(maxCleanDate) && cleanCount < limitQuantity && ++loopCount <= 10000);
        log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u5171\u6e05\u7406[%s]\u6761\u6570\u636e", configParam.getMainEntityNumber(), cleanCount));
    }

    protected int executeEverySegment(CleanTaskConfigParam configParam, int everytimeCount, Date seekDate, Date maxCleanDate) {
        int stepLength = configParam.getStepLength() == 0 ? 3 : configParam.getStepLength();
        Date endingDate = this.getTargetTime(seekDate, stepLength);
        if (endingDate.after(maxCleanDate)) {
            endingDate = maxCleanDate;
        }
        String orderBys = String.format("%s asc", configParam.getSeekFieldName());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter(configParam.getSeekFieldName(), "<=", (Object)endingDate));
        filters.add(new QFilter(configParam.getSeekFieldName(), ">=", (Object)seekDate));
        if (configParam.getConditionFilters() != null) {
            filters.add(configParam.getConditionFilters());
        }
        String pkFeild = EntityMetadataCache.getDataEntityType((String)configParam.getMainEntityNumber()).getPrimaryKey().getName();
        String selectFieldStr = String.format("%s,%s", pkFeild, configParam.getSeekFieldName());
        ArrayList<Object> pks = new ArrayList<Object>(2000);
        int i = 0;
        Date startingDate = (Date)configParam.getParams().get(VALUE_STARTINGDATE);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DefaultRegularTimeCleaner.executeEverySegment", (String)configParam.getMainEntityNumber(), (String)selectFieldStr, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys, (int)everytimeCount);){
            Row row = null;
            while (dataSet != null && dataSet.hasNext()) {
                row = dataSet.next();
                pks.add(row.get(pkFeild));
                startingDate = seekDate = row.getDate(configParam.getSeekFieldName());
                if (++i % 2000 != 0) continue;
                this.disposePartData(pkFeild, pks, configParam);
                pks.clear();
            }
            if (row == null) {
                seekDate = endingDate;
            }
            if (i % 2000 > 0) {
                this.disposePartData(pkFeild, pks, configParam);
            }
        }
        configParam.getParams().put(VALUE_STARTINGDATE, startingDate);
        configParam.getParams().put(VALUE_SEEKDATE, seekDate);
        log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u5206\u6279\u6b21\u6e05\u7406\uff0c\u672c\u6279\u6b21\u5171\u6e05\u7406[%s]\u6761\u6570\u636e", configParam.getMainEntityNumber(), i));
        return i;
    }

    protected void updateStartingDate(CleanTaskConfigParam configParam) {
        configParam.getParams().remove(VALUE_SEEKDATE);
        Date startingDate = (Date)configParam.getParams().remove(VALUE_STARTINGDATE);
        if (startingDate != null) {
            configParam.getParams().put(VALUE_STARTINGTIME, startingDate.getTime());
        }
    }

    private void disposePartData(String pkFeild, List<Object> pks, CleanTaskConfigParam configParam) {
        if (WfUtils.isEmptyForCollection(pks)) {
            return;
        }
        if (configParam.getRelaCleanConfigParams() != null) {
            for (RelaCleanConfigParam relaParam : configParam.getRelaCleanConfigParams()) {
                this.disposeRelaEntityData(pks, relaParam, configParam.getDisposalType());
            }
        }
        this.disposeMainEntityData(pkFeild, pks, configParam);
    }

    protected Date getRealStartingDate(CleanTaskConfigParam configParam, Date maxCleanDate) {
        String orderBys = String.format("%s asc", configParam.getSeekFieldName());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter(configParam.getSeekFieldName(), "<=", (Object)maxCleanDate));
        if (configParam.getConditionFilters() != null) {
            filters.add(configParam.getConditionFilters());
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DefaultRegularTimeCleaner.getRealStartingDate", (String)configParam.getMainEntityNumber(), (String)configParam.getSeekFieldName(), (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys, (int)1);){
            if (dataSet != null && dataSet.hasNext()) {
                Row row = dataSet.next();
                Date date = row.getDate(configParam.getSeekFieldName());
                return date;
            }
        }
        return null;
    }

    protected int getDefaultStepLimitQuantity() {
        return 50000;
    }

    protected int getDefaultLimitQuantity() {
        return 5000000;
    }

    protected Date getNextSeekDate(CleanTaskConfigParam configParam) {
        return (Date)configParam.getParams().get(VALUE_SEEKDATE);
    }

    protected boolean validateParam(CleanTaskConfigParam configParam) {
        boolean result = true;
        if (WfUtils.isEmpty(configParam.getMainEntityNumber())) {
            log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u6267\u884c\u6e05\u7406\u5931\u8d25\uff0cmainEntityNumber \u4e3a\u7a7a\uff01", configParam.getMainEntityNumber()));
            result = false;
        }
        if (WfUtils.isEmpty(configParam.getSeekFieldName())) {
            log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u6267\u884c\u6e05\u7406\u5931\u8d25\uff0cseekFieldName \u4e3a\u7a7a\uff01", configParam.getMainEntityNumber()));
            result = false;
        }
        return result;
    }
}

