/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.cleaner;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bec.engine.BecSystemParamterUtils;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.cleaner.RegularTimeCleaner;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;

public class EvtLogCleaner
implements RegularTimeCleaner {
    private static Log log = LogFactory.getLog(EvtLogCleaner.class);
    private static final String VALUE_STARTINGTIME = "startingTime";
    private static final String CREATEDATE = "createdate";
    private static final String VALUE_BECDELETELOGCURSOR = "becDeleteLogCursor";
    private static final String VALUE_STARTINGREALTIME = "ormStartingRealTime";
    Integer sysParam = BecSystemParamterUtils.getRetentionTime();

    @Override
    public Map<String, Object> execute(CleanTaskConfigParam configParam) {
        HashMap<String, Object> params;
        Object paramMap;
        log.debug("\u6361\u6f0f\u5220\u9664\u83b7\u53d6\u53c2\u6570\u96c6\u5408\u3002");
        Long startingTime = null;
        String sql = "SELECT TOP 1 FPARAMS FROM T_WF_CLEANDYNAMICCONFIG WHERE FCLEANMODE = 'timing' AND FENTITYNUMBER = 'evt_hijob';";
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.evt.EvtLogCleaner", (DBRoute)DBRoute.workflow, (String)sql, null);){
            if (ds != null && ds.hasNext()) {
                String param = ds.next().getString("FPARAMS");
                if (WfUtils.isEmpty(param)) {
                    log.debug("\u6361\u6f0f\u5220\u9664\u83b7\u53d6\u5230\u53c2\u6570\u4e3a\u7a7a\u3002");
                    Map<String, Object> map = null;
                    return map;
                }
                paramMap = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
                if (paramMap.get(VALUE_STARTINGTIME) == null) {
                    log.debug("\u6361\u6f0f\u5220\u9664\u83b7\u53d6\u65f6\u95f4\u4e3a\u7a7a\u3002");
                    Map<String, Object> map = null;
                    return map;
                }
                startingTime = Long.valueOf(paramMap.get(VALUE_STARTINGTIME).toString());
                log.debug("\u6361\u6f0f\u5220\u9664\u83b7\u53d6\u7684\u65f6\u95f4\uff1a" + startingTime);
            }
        }
        if (startingTime == null) {
            log.debug("\u6361\u6f0f\u5220\u9664\u65f6\u95f4\u4e3a\u7a7a\u3002");
            return null;
        }
        boolean deleteFlag = false;
        String sqlLog = "SELECT TOP 1 FCREATEDATE FROM T_EVT_LOG ORDER BY FCREATEDATE DESC;";
        DataSet ds = DB.queryDataSet((String)"wf.engine.evtlog", (DBRoute)DBRoute.workflow, (String)sqlLog, null);
        paramMap = null;
        try {
            Date date;
            if (ds != null && ds.hasNext() && (date = ds.next().getDate("FCREATEDATE")) != null && date.after(new Date(startingTime))) {
                deleteFlag = true;
            }
        }
        catch (Throwable date) {
            paramMap = date;
            throw date;
        }
        finally {
            if (ds != null) {
                if (paramMap != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable date) {
                        ((Throwable)paramMap).addSuppressed(date);
                    }
                } else {
                    ds.close();
                }
            }
        }
        Map<Object, Object> map = params = configParam.getParams() == null ? new HashMap(16) : configParam.getParams();
        if (deleteFlag) {
            int maxDeleteCountLog = configParam.getLimitQuantity() == 0 ? 2000000 : configParam.getLimitQuantity();
            int everytimeDeleteCountLog = configParam.getStepLimitQuantity() == 0 ? 50000 : configParam.getStepLimitQuantity();
            return this.deleteEventClosedJobLoop(params, startingTime, maxDeleteCountLog, everytimeDeleteCountLog);
        }
        return this.deleteLogOrmLoop(params, startingTime, configParam.getStepLength());
    }

    Map<String, Object> deleteEventClosedJobLoop(Map<String, Object> params, Long startingTime, int maxDeleteCountLog, int everytimeDeleteCountLog) {
        try {
            int i;
            Long becDeleteLogCursor = this.convertLong(-1L, params.get(VALUE_BECDELETELOGCURSOR));
            int times = maxDeleteCountLog / everytimeDeleteCountLog + (maxDeleteCountLog % everytimeDeleteCountLog != 0 ? 1 : 0);
            for (i = 0; i < times; ++i) {
                Long id = this.deleteEventClosedJob(everytimeDeleteCountLog, startingTime, becDeleteLogCursor);
                if (id == null) {
                    log.debug(String.format("\u7b2c%1$s\u6279\u5220\u9664\u7ed3\u675f\u3002", i + 1));
                    break;
                }
                becDeleteLogCursor = id;
            }
            if (i > 0) {
                params.put(VALUE_BECDELETELOGCURSOR, becDeleteLogCursor);
                log.debug(String.format("\u7b2c%1$s\u5168\u90e8\u5220\u9664\u7ed3\u675f,\u66f4\u65b0\u540e\u7684\u4e8b\u4ef6\u53c2\u6570\u4e3a%2$s", i, params.toString()));
                return params;
            }
        }
        catch (Exception e) {
            log.error(String.format("\u4e8b\u4ef6\u4e2d\u5fc3\u6361\u6f0f\u5220\u9664\u5931\u8d25\u3002 %s", WfUtils.getExceptionStacktrace(e)));
        }
        return null;
    }

    Map<String, Object> deleteLogOrmLoop(Map<String, Object> params, Long startingTime, int stepLength) {
        try {
            int i;
            if (stepLength <= 0) {
                log.debug("\u4e8b\u4ef6\u4e2d\u5fc3\u6361\u6f0f\u5220\u9664\u65e5\u5fd7\u8868\u5355\u6b65\u957f\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u9000\u51fa\u3002");
                return null;
            }
            Long startingRealTime = this.convertLong(1685548800000L, params.get(VALUE_STARTINGREALTIME));
            for (i = 0; i < stepLength; ++i) {
                Long date = this.deleteLogOrmExecute(startingTime, startingRealTime);
                if (date == null) {
                    log.debug(String.format("\u7b2c%1$s\u6279\u5220\u9664\u65e5\u5fd7\u8868\u5355\u7ed3\u675f\u3002", i + 1));
                    break;
                }
                startingRealTime = date;
            }
            if (i > 0) {
                params.put(VALUE_STARTINGREALTIME, startingRealTime);
                log.debug(String.format("\u7b2c%1$s\u5168\u90e8\u5220\u9664\u65e5\u5fd7\u8868\u5355\u7ed3\u675f, \u66f4\u65b0\u540e\u7684\u4e8b\u4ef6\u53c2\u6570\u4e3a%2$s", i, params.toString()));
                return params;
            }
        }
        catch (Exception e) {
            log.error(String.format("\u4e8b\u4ef6\u4e2d\u5fc3\u6361\u6f0f\u5220\u9664\u65e5\u5fd7\u8868\u5355\u5931\u8d25\u3002 %s", WfUtils.getExceptionStacktrace(e)));
        }
        return null;
    }

    private Long convertLong(Long defaultVal, Object obj) {
        if (obj != null) {
            return (Long)obj;
        }
        return defaultVal;
    }

    private Long deleteEventClosedJob(Integer maxcount, Long startingTime, Long becDeleteLogCursor) {
        Date startingDate = new Date(startingTime);
        QFilter filter = new QFilter(CREATEDATE, "<", (Object)startingDate);
        QFilter filter1 = new QFilter("id", ">", (Object)becDeleteLogCursor);
        QFilter[] filters = new QFilter[]{filter, filter1};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"EvtLogCleaner", (String)"evt_log", (String)"id", (QFilter[])filters, (String)"id asc", (int)maxcount);){
            int i = 0;
            ArrayList<Object> idList = new ArrayList<Object>(16);
            Long id = null;
            while (dataSet != null && dataSet.hasNext()) {
                id = Long.valueOf(dataSet.next().getString("id"));
                idList.add(id);
                if (++i % 2000 != 0) continue;
                this.deleteEventClosedExecute(idList);
                idList.clear();
            }
            if (i % 2000 > 0) {
                this.deleteEventClosedExecute(idList);
            }
            log.debug(String.format("the log size is %s", i));
            if (id == null) {
                Long l = null;
                return l;
            }
            Long l = id;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEventClosedExecute(List<Object> idList) {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        try (TXHandle handle = TX.requiresNew();){
            log.debug("\u6361\u6f0f\u5220\u9664\u5f00\u59cb\u6267\u884c\uff1a");
            String sql = "DELETE FROM T_EVT_LOG WHERE FID in ( ? ) ;";
            WfDBUtils.executeBatchDeleteByIn(sql, idList, 500, true);
            log.debug("\u6361\u6f0fT_EVT_LOG\u4e2d\u5df2\u7ed3\u675f\u4e8b\u4ef6 \u7684\u8bb0\u5f55...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long deleteLogOrmExecute(Long startingTime, Long startingRealTime) {
        if (startingTime <= startingRealTime) {
            return null;
        }
        Date startingRealDate = new Date(startingRealTime);
        startingTime = startingRealTime + 86400000L > startingTime ? startingTime : startingRealTime + 86400000L;
        Date startingDate = new Date(startingTime);
        QFilter filter = new QFilter("opdate", "<", (Object)startingDate);
        QFilter filter1 = new QFilter("opdate", ">=", (Object)startingRealDate);
        QFilter[] filters = new QFilter[]{filter, filter1};
        try (TXHandle handle = TX.requiresNew();){
            log.debug("\u6361\u6f0f\u5220\u9664orm\u5f00\u59cb\u6267\u884c\uff1a");
            int deleteCount = LogORM.create().delete("evt_loges", filters);
            log.debug(String.format("\u6361\u6f0fT_EVT_LOGS\u4e2d\u5df2\u7ed3\u675f\u4e8b\u4ef6 \u7684\u8bb0\u5f55,\u5171%s\u6761\u8bb0\u5f55", deleteCount));
        }
        return startingTime;
    }
}

