/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.cleaner;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.cleaner.DefaultProcessCleaner;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class LogProcessCleaner
extends DefaultProcessCleaner {
    private static Log log = LogFactory.getLog(LogProcessCleaner.class);

    @Override
    public void execute(CommandContext commandContext, CleanTaskConfigParam configParam, List<String> businessKeys, List<Long> procInstIds) {
        if (WfUtils.isEmpty(configParam.getMainEntityNumber())) {
            log.debug(String.format("\u6309\u6d41\u7a0b\u6e05\u7406\u65e5\u5fd7\u8868\u5355[%s]\u6267\u884c\u6e05\u7406\u5931\u8d25\uff0cmainEntityNumber \u4e3a\u7a7a\uff01", configParam.getMainEntityNumber()));
            return;
        }
        String cleanIndex = configParam.getCleanIndex();
        log.debug(String.format("\u6309\u6d41\u7a0b\u6e05\u7406\u65e5\u5fd7\u8868\u5355[%s]\u5f00\u59cb\u6267\u884c\u6e05\u7406\uff01\u6e05\u7406\u65f6\u673a[%s]\uff0c\u6e05\u7406\u7d22\u5f15[%s]", configParam.getMainEntityNumber(), configParam.getCleanMoment(), cleanIndex));
        String cleanIndexfeild = this.getCleanIndexFeild(configParam.getMainEntityNumber(), cleanIndex);
        if (WfUtils.isEmpty(cleanIndexfeild)) {
            log.debug(String.format("\u6309\u6d41\u7a0b\u6e05\u7406\u65e5\u5fd7\u8868\u5355[%s]\u6267\u884c\u6e05\u7406\u5931\u8d25\uff0ccleanIndexfeild \u4e3a\u7a7a\uff01\u6e05\u7406\u65f6\u673a[%s]\uff0c\u6e05\u7406\u7d22\u5f15[%s]", configParam.getMainEntityNumber(), configParam.getCleanMoment(), cleanIndex));
            return;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (configParam.getConditionFilters() != null) {
            filters.add(configParam.getConditionFilters());
        }
        switch (cleanIndex) {
            case "businessKey": {
                filters.add(new QFilter(cleanIndexfeild, "in", businessKeys));
                break;
            }
            case "processInstanceId": {
                filters.add(new QFilter(cleanIndexfeild, "in", procInstIds));
                break;
            }
        }
        try {
            LogORM.create().delete(configParam.getMainEntityNumber(), filters.toArray(new QFilter[0]));
        }
        catch (Throwable ex) {
            log.error("deleteData is error, errorinfo is :" + WfUtils.getExceptionStacktrace(ex));
        }
        log.debug(String.format("\u6309\u6d41\u7a0b\u6e05\u7406\u65e5\u5fd7\u8868\u5355[%s]\u6267\u884c\u5b8c\u6210\uff01", configParam.getMainEntityNumber()));
    }
}

