/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.cleaner;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.cleaner.DefaultRegularTimeCleaner;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;

public class LogRegularTimeCleaner
extends DefaultRegularTimeCleaner {
    private static Log log = LogFactory.getLog(LogRegularTimeCleaner.class);

    @Override
    public Map<String, Object> execute(CleanTaskConfigParam configParam) {
        LogORM logORM = LogORM.create();
        Map<String, Object> parameters = configParam.getParams();
        if (parameters == null) {
            parameters = new HashMap<String, Object>(1);
            configParam.setParams(parameters);
        }
        if (WfUtils.isEmpty(configParam.getMainEntityNumber())) {
            log.warn(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u65e5\u5fd7\u8868\u5355[%s]\u6267\u884c\u6e05\u7406\u5931\u8d25\uff0cmainEntityNumber \u4e3a\u7a7a\uff01", configParam.getMainEntityNumber()));
            return configParam.getParams();
        }
        if (WfUtils.isEmpty(configParam.getSeekFieldName())) {
            log.warn(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u65e5\u5fd7\u8868\u5355[%s]\u6267\u884c\u6e05\u7406\u5931\u8d25\uff0cseekFieldName \u4e3a\u7a7a\uff01", configParam.getMainEntityNumber()));
            return configParam.getParams();
        }
        String mainEntityNumber = configParam.getMainEntityNumber();
        int retentionTime = configParam.getRetentionTime() == 0 ? 15 : configParam.getRetentionTime();
        log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u65e5\u5fd7\u8868\u5355[%s]\u5f00\u59cb\u6267\u884c\u6e05\u7406\uff01\u4fdd\u7559\u65f6\u95f4[%s]", configParam.getMainEntityNumber(), retentionTime));
        Date maxCleanDate = this.getTargetTime(WfUtils.now(), -retentionTime);
        Date startingDate = null;
        if (parameters.get("startingTime") != null) {
            startingDate = new Date((Long)parameters.get("startingTime"));
        } else {
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                startingDate = dt.parse("2023-06-01 00:00:00");
            }
            catch (ParseException e) {
                log.error("init startingDate is error, errorinfo is :" + WfUtils.getExceptionStacktrace(e));
                return configParam.getParams();
            }
        }
        int stepLength = configParam.getStepLength() == 0 ? 3 : configParam.getStepLength();
        for (int loopCount = 0; !startingDate.equals(maxCleanDate) && !startingDate.after(maxCleanDate) && loopCount <= 10000; ++loopCount) {
            Date endingDate = this.getTargetTime(startingDate, stepLength);
            if (endingDate.after(maxCleanDate)) {
                endingDate = maxCleanDate;
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            filters.add(new QFilter(configParam.getSeekFieldName(), "<=", (Object)endingDate));
            filters.add(new QFilter(configParam.getSeekFieldName(), ">=", (Object)startingDate));
            if (configParam.getConditionFilters() != null) {
                filters.add(configParam.getConditionFilters());
            }
            try {
                logORM.delete(mainEntityNumber, filters.toArray(new QFilter[0]));
            }
            catch (Throwable ex) {
                log.error("deleteData is error, errorinfo is :" + WfUtils.getExceptionStacktrace(ex));
            }
            log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u65e5\u5fd7\u8868\u5355[%s]\u5206\u6279\u6b21\u6e05\u7406\uff0c\u6e05\u7406\u6761\u4ef6[%s]\uff01", mainEntityNumber, filters));
            startingDate = endingDate;
        }
        configParam.getParams().put("startingTime", startingDate.getTime());
        log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u65e5\u5fd7\u8868\u5355[%s]\u5f00\u59cb\u6267\u884c\u6e05\u7406\uff01", configParam.getMainEntityNumber()));
        return configParam.getParams();
    }
}

