/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.cleaner;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.cleaner.DefaultRegularTimeCleaner;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;
import kd.bos.workflow.engine.impl.clean.model.RelaCleanConfigParam;

public class PluginExeRecordCleaner
extends DefaultRegularTimeCleaner {
    private static final String ENTITY_WF_PLUGINPROCINFO = "wf_pluginprocinfo";
    private static final String ENTITY_WF_PLUGINEXESUMMARY = "wf_pluginexesummary";
    private static final String PROCESSNO = "processno";
    private static final String PLUGINNO = "pluginno";
    private static final String ELEMENTID = "elementid";
    private static final String DURATION = "duration";
    private static final String ID = "id";
    private static final String TOTALDURATION = "totalduration";
    private static final String EXECUTEDTIMES = "executedtimes";
    private static final String AVERAGEDURATION = "averageduration";
    private static final String EMPTY = "ELEMENTID_EMPTY";
    private static Log log = LogFactory.getLog(PluginExeRecordCleaner.class);

    @Override
    public Map<String, Object> execute(CleanTaskConfigParam configParam) {
        log.debug("PluginExeRecordCleaner is executing");
        int stepLimitQuantity = configParam.getStepLimitQuantity() == 0 ? 50000 : configParam.getStepLimitQuantity();
        this.executeBySegment(configParam, stepLimitQuantity);
        return null;
    }

    protected int executeBySegment(CleanTaskConfigParam configParam, int everytimeCount) {
        String orderBys = String.format("%s asc", configParam.getSeekFieldName());
        int retentionTime = configParam.getRetentionTime() == 0 ? 3 : configParam.getRetentionTime();
        Calendar oneMonthCalendar = Calendar.getInstance();
        oneMonthCalendar.setTime(WfUtils.now());
        oneMonthCalendar.add(5, -retentionTime);
        Date queryMonthCalendar = oneMonthCalendar.getTime();
        QFilter qFilter = new QFilter("begintime", "<", (Object)queryMonthCalendar);
        String selectFields = "id,processno,pluginno,procinstid,duration,elementid";
        HashMap<String, PluginInfo> colDataMap = new HashMap<String, PluginInfo>(8);
        int i = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PluginExeRecordCleaner.executeEverySegment", (String)configParam.getMainEntityNumber(), (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)orderBys, (int)everytimeCount);){
            Row row = null;
            while (dataSet != null && dataSet.hasNext()) {
                ++i;
                row = dataSet.next();
                String pluginNo = row.getString(PLUGINNO);
                String processNo = row.getString(PROCESSNO);
                String elementId = WfUtils.isEmpty(row.getString(ELEMENTID)) ? EMPTY : row.getString(ELEMENTID);
                Long id = row.getLong(ID);
                String jointStr = pluginNo + "#" + processNo + "#" + elementId;
                Long duration = row.getLong(DURATION);
                colDataMap.put(jointStr, this.buildPluginInfoObject(jointStr, id, duration, colDataMap));
                if (i % 2000 != 0) continue;
                this.executeDealData(colDataMap);
                colDataMap.clear();
            }
            if (i % 2000 > 0) {
                this.executeDealData(colDataMap);
            }
        }
        configParam.getParams().put("startingTime", queryMonthCalendar.getTime());
        this.updateTimeLine(configParam);
        log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u5206\u6279\u6b21\u6e05\u7406\uff0c\u672c\u6279\u6b21\u5171\u6e05\u7406[%s]\u6761\u6570\u636e", configParam.getMainEntityNumber(), i));
        return i;
    }

    private PluginInfo buildPluginInfoObject(String jointStr, Long id, Long duration, Map<String, PluginInfo> colDataMap) {
        PluginInfo pluginInfo = null;
        pluginInfo = colDataMap != null && colDataMap.get(jointStr) != null ? colDataMap.get(jointStr) : new PluginInfo();
        pluginInfo.setDuration(duration);
        String pluginNo = jointStr.split("#")[0];
        String processNo = jointStr.split("#")[1];
        pluginInfo.setPluginno(pluginNo);
        pluginInfo.setProcessno(processNo);
        List<Object> oldIds = pluginInfo.getIds() == null ? new ArrayList(8) : pluginInfo.getIds();
        oldIds.add(id);
        pluginInfo.setIds(oldIds);
        pluginInfo.setExecutedTimes(pluginInfo.getExecutedTimes() == null ? 1L : pluginInfo.getExecutedTimes() + 1L);
        Long detailDurations = pluginInfo.getDetailDurations() == null ? duration : pluginInfo.getDetailDurations() + duration;
        pluginInfo.setDetailDurations(detailDurations);
        return pluginInfo;
    }

    private void executeDealData(Map<String, PluginInfo> colDataMap) {
        ArrayList<Map<String, Object>> updatePluginProcess = new ArrayList<Map<String, Object>>(16);
        ArrayList<Map<String, Object>> updateSummary = new ArrayList<Map<String, Object>>(16);
        ArrayList<Long> detailIds = new ArrayList<Long>(16);
        if (WfUtils.isNotEmptyForMap(colDataMap)) {
            for (Map.Entry<String, PluginInfo> map : colDataMap.entrySet()) {
                Map<String, Long> summaryMap;
                Map<String, Long> pluginProcessMap;
                String jointStr = map.getKey();
                String pluginNo = jointStr.split("#")[0];
                String processNo = jointStr.split("#")[1];
                String elementId = jointStr.split("#")[2];
                PluginInfo pluginInfo = map.getValue();
                if (WfUtils.isNotEmptyForCollection(pluginInfo.getIds())) {
                    detailIds.addAll(pluginInfo.getIds());
                }
                if ((pluginProcessMap = this.findPluginProcessByJointStr(pluginNo, processNo, elementId)).size() > 0) {
                    Map<String, Object> updatePluginProcessMap = this.reCalculatePluginProcess(pluginProcessMap, pluginInfo);
                    updatePluginProcess.add(updatePluginProcessMap);
                }
                if ((summaryMap = this.findPluginSummaryByPluginNo(pluginNo)).size() <= 0) continue;
                Map<String, Object> updateSummaryPlugin = this.reCalculatePluginSummary(summaryMap, pluginInfo);
                updateSummary.add(updateSummaryPlugin);
            }
        }
        this.executeBatchUpdate(detailIds, updatePluginProcess, updateSummary);
    }

    private Map<String, Long> findPluginProcessByJointStr(String pluginNo, String processNo, String elementId) {
        HashMap<String, Long> ret = new HashMap<String, Long>(8);
        String selectFields = "id,processno,pluginno,executedtimes,totalduration";
        QFilter qFPluginNo = new QFilter(PLUGINNO, "=", (Object)pluginNo);
        QFilter qFProcessNo = new QFilter(PROCESSNO, "=", (Object)processNo);
        QFilter[] qFilters = null;
        if (EMPTY.equalsIgnoreCase(elementId)) {
            qFilters = new QFilter[]{qFPluginNo, qFProcessNo};
        } else {
            QFilter qfElementId = new QFilter(ELEMENTID, "=", (Object)elementId);
            qFilters = new QFilter[]{qFPluginNo, qFProcessNo, qfElementId};
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PluginExeRecordCleaner.findPluginProcessByJointStr", (String)ENTITY_WF_PLUGINPROCINFO, (String)selectFields, (QFilter[])qFilters, null);){
            Row row = null;
            if (dataSet != null && dataSet.hasNext()) {
                row = dataSet.next();
                ret.put(EXECUTEDTIMES, row.getLong(EXECUTEDTIMES));
                ret.put(TOTALDURATION, row.getLong(TOTALDURATION));
                ret.put(ID, row.getLong(ID));
            }
        }
        return ret;
    }

    private Map<String, Long> findPluginSummaryByPluginNo(String pluginNo) {
        HashMap<String, Long> ret = new HashMap<String, Long>(8);
        String pluginSummarySelectFields = "id,pluginno,totalduration,executedtimes,averageduration";
        QFilter qFPluginNo = new QFilter(PLUGINNO, "=", (Object)pluginNo);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PluginExeRecordCleaner.findPluginSummaryByPluginNo", (String)ENTITY_WF_PLUGINEXESUMMARY, (String)pluginSummarySelectFields, (QFilter[])new QFilter[]{qFPluginNo}, null);){
            Row row = null;
            if (dataSet != null && dataSet.hasNext()) {
                row = dataSet.next();
                ret.put(EXECUTEDTIMES, row.getLong(EXECUTEDTIMES));
                ret.put(TOTALDURATION, row.getLong(TOTALDURATION));
                ret.put(ID, row.getLong(ID));
            }
        }
        return ret;
    }

    private Map<String, Object> reCalculatePluginProcess(Map<String, Long> pluginProcessMap, PluginInfo pluginInfo) {
        HashMap<String, Object> updatePluginProcessMap = new HashMap<String, Object>(8);
        Long detailTotalDuration = 0L;
        if (pluginInfo.getDetailDurations() != null) {
            detailTotalDuration = pluginInfo.getDetailDurations();
        }
        Long executedtimes = pluginProcessMap.get(EXECUTEDTIMES) < 0L ? Long.valueOf(0L) : pluginProcessMap.get(EXECUTEDTIMES);
        Long oldTotalDuration = pluginProcessMap.get(TOTALDURATION) == null ? Long.valueOf(0L) : pluginProcessMap.get(TOTALDURATION);
        Long newTotalDuration = oldTotalDuration - detailTotalDuration < 0L ? 0L : oldTotalDuration - detailTotalDuration;
        Long newExecutedtimes = executedtimes - pluginInfo.getExecutedTimes() < 0L ? 0L : executedtimes - pluginInfo.getExecutedTimes();
        Long newAverageduration = 0L;
        if (newExecutedtimes >= 1L) {
            newAverageduration = newTotalDuration / newExecutedtimes;
        }
        updatePluginProcessMap.put(EXECUTEDTIMES, newExecutedtimes);
        updatePluginProcessMap.put(AVERAGEDURATION, newAverageduration);
        updatePluginProcessMap.put(TOTALDURATION, newTotalDuration);
        updatePluginProcessMap.put(ID, pluginProcessMap.get(ID));
        return updatePluginProcessMap;
    }

    private Map<String, Object> reCalculatePluginSummary(Map<String, Long> summaryMap, PluginInfo pluginInfo) {
        HashMap<String, Object> updateSummaryPlugin = new HashMap<String, Object>(8);
        Long detailTotalDuration = 0L;
        if (pluginInfo.getDetailDurations() != null) {
            detailTotalDuration = pluginInfo.getDetailDurations();
        }
        Long totalDuartion = summaryMap.get(TOTALDURATION) < 0L ? Long.valueOf(0L) : summaryMap.get(TOTALDURATION);
        Long executedtimes = summaryMap.get(EXECUTEDTIMES) < 0L ? Long.valueOf(0L) : summaryMap.get(EXECUTEDTIMES);
        Long newTotalDuration = totalDuartion - detailTotalDuration < 0L ? 0L : totalDuartion - detailTotalDuration;
        Long newExecutedtimes = executedtimes - pluginInfo.getExecutedTimes() < 0L ? 0L : executedtimes - pluginInfo.getExecutedTimes();
        Long newAverageduration = 0L;
        if (newExecutedtimes > 0L) {
            newAverageduration = newTotalDuration / newExecutedtimes;
        }
        updateSummaryPlugin.put(TOTALDURATION, newTotalDuration);
        updateSummaryPlugin.put(EXECUTEDTIMES, newExecutedtimes);
        updateSummaryPlugin.put(AVERAGEDURATION, newAverageduration);
        updateSummaryPlugin.put(ID, summaryMap.get(ID));
        return updateSummaryPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatchUpdate(List<Long> ids, List<Map<String, Object>> updateSummary, List<Map<String, Object>> updatePluginProcess) {
        try (TXHandle handle = TX.requiresNew();){
            ArrayList<Object[]> params;
            if (ids.size() > 0) {
                ArrayList<Object[]> detailIds = new ArrayList<Object[]>(ids.size());
                for (int i = 0; i < ids.size(); ++i) {
                    detailIds.add(new Object[]{ids.get(i)});
                }
                String deleteDetailSql = "delete  from  t_wf_pluginexedetail  where  fid= ? ;";
                WfDBUtils.executeBatch(deleteDetailSql, detailIds, 1000);
                String deleteDetailMiltSql = "delete  from  t_wf_pluginexedetail_l  where  fid= ?; ";
                WfDBUtils.executeBatch(deleteDetailMiltSql, detailIds, 1000);
                log.debug(String.format("delete t_wf_pluginexedetail\uff0c\u6267\u884c\u6210\u529f\uff01\u6570\u636e\u91cf[%s]", detailIds.size()));
            }
            if (updateSummary.size() > 0) {
                String updateSummarySql = " update t_wf_pluginexesummary set  ftotalduration =?, faverageduration =? ,fexecutedtimes =?   where  fid=? ;";
                params = new ArrayList<Object[]>(updateSummary.size());
                updateSummary.forEach(map -> {
                    Object[] tmp = new Object[]{map.get(TOTALDURATION), map.get(AVERAGEDURATION), map.get(EXECUTEDTIMES), map.get(ID)};
                    params.add(tmp);
                });
                WfDBUtils.executeBatch(updateSummarySql, params, 500);
                log.debug(String.format("update t_wf_pluginexesummary\uff0c\u6267\u884c\u6210\u529f\uff01\u6570\u636e\u91cf[%s]", updateSummary.size()));
            }
            if (updatePluginProcess.size() > 0) {
                String updatePluginProcessSql = " update t_wf_pluginprocinfo  set fexecutedtimes =? ,faverageduration =?,ftotalduration=?  where  fid=? ;";
                params = new ArrayList(updatePluginProcess.size());
                updateSummary.forEach(map -> {
                    Object[] tmp = new Object[]{map.get(EXECUTEDTIMES), map.get(AVERAGEDURATION), map.get(TOTALDURATION), map.get(ID)};
                    params.add(tmp);
                });
                WfDBUtils.executeBatch(updatePluginProcessSql, params, 1000);
                log.debug(String.format("update t_wf_pluginprocinfo\uff0c\u6267\u884c\u6210\u529f\uff01\u6570\u636e\u91cf[%s]", updatePluginProcess.size()));
            }
        }
    }

    private void updateTimeLine(CleanTaskConfigParam configParam) {
        if (configParam.getParams() != null) {
            String paramsStr = SerializationUtils.toJsonString(configParam.getParams());
            String entityNumber = configParam.getMainEntityNumber();
            QFilter[] filters = new QFilter[]{new QFilter("entitynumber", "=", (Object)entityNumber), new QFilter("cleanmode", "=", (Object)"timing"), new QFilter("order", "=", (Object)configParam.getOrder())};
            DynamicObject dynConfig = QueryServiceHelper.queryOne((String)"wf_cleandynamicconfig", (String)"id,params", (QFilter[])filters);
            if (dynConfig == null) {
                dynConfig = BusinessDataServiceHelper.newDynamicObject((String)"wf_cleandynamicconfig");
                dynConfig.set("entitynumber", (Object)entityNumber);
                dynConfig.set("cleanmode", (Object)"timing");
                dynConfig.set("params", (Object)paramsStr);
                dynConfig.set("order", (Object)configParam.getOrder());
                dynConfig.set("status", (Object)"1");
                StringBuilder relaStr = new StringBuilder();
                List<RelaCleanConfigParam> relaList = configParam.getRelaCleanConfigParams();
                if (WfUtils.isNotEmptyForCollection(relaList)) {
                    for (RelaCleanConfigParam rela : relaList) {
                        relaStr.append(rela.getRelaEntityNumber()).append(",");
                    }
                    dynConfig.set("relaentity", (Object)relaStr.substring(0, relaStr.length() - 1));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynConfig});
            } else {
                Object[] sqlParam = new Object[]{paramsStr, dynConfig.get(ID)};
                String sql = "update t_wf_cleandynamicconfig set fparams = ? where fid = ?;";
                DB.execute((DBRoute)DBRoute.workflow, (String)sql, (Object[])sqlParam);
            }
        }
    }

    static class PluginInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String processno;
        private String pluginno;
        private String businesskey;
        private Long procinstid;
        private Long duration;
        private Long id;
        private List<Long> ids;
        private Long executedTimes;
        private Long detailDurations;

        PluginInfo() {
        }

        public Long getDetailDurations() {
            return this.detailDurations;
        }

        public void setDetailDurations(Long detailDurations) {
            this.detailDurations = detailDurations;
        }

        public Long getExecutedTimes() {
            return this.executedTimes;
        }

        public void setExecutedTimes(Long executedTimes) {
            this.executedTimes = executedTimes;
        }

        public List<Long> getIds() {
            return this.ids;
        }

        public void setIds(List<Long> ids) {
            this.ids = ids;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getDuration() {
            return this.duration;
        }

        public void setDuration(Long duration) {
            this.duration = duration;
        }

        public String getProcessno() {
            return this.processno;
        }

        public void setProcessno(String processno) {
            this.processno = processno;
        }

        public String getPluginno() {
            return this.pluginno;
        }

        public void setPluginno(String pluginno) {
            this.pluginno = pluginno;
        }

        public String getBusinesskey() {
            return this.businesskey;
        }

        public void setBusinesskey(String businesskey) {
            this.businesskey = businesskey;
        }

        public Long getProcinstid() {
            return this.procinstid;
        }

        public void setProcinstid(Long procinstid) {
            this.procinstid = procinstid;
        }
    }
}

