/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.cleaner;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.impl.clean.cleaner.DefaultRegularTimeCleaner;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;

public class TaskJobRecordCleaner
extends DefaultRegularTimeCleaner {
    private static Log log = LogFactory.getLog(TaskJobRecordCleaner.class);

    @Override
    public Map<String, Object> execute(CleanTaskConfigParam configParam) {
        return super.execute(configParam);
    }

    @Override
    protected int executeEverySegment(CleanTaskConfigParam configParam, int everytimeCount, Date seekDate, Date maxCleanDate) {
        int stepLength = configParam.getStepLength() == 0 ? 3 : configParam.getStepLength();
        Date endingDate = this.getTargetTime(seekDate, stepLength);
        if (endingDate.after(maxCleanDate)) {
            endingDate = maxCleanDate;
        }
        String orderBys = String.format("%s asc", configParam.getSeekFieldName());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter(configParam.getSeekFieldName(), "<=", (Object)endingDate));
        filters.add(new QFilter(configParam.getSeekFieldName(), ">=", (Object)seekDate));
        if (configParam.getConditionFilters() != null) {
            filters.add(configParam.getConditionFilters());
        }
        String pkFeild = EntityMetadataCache.getDataEntityType((String)configParam.getMainEntityNumber()).getPrimaryKey().getName();
        String selectFieldStr = String.format("%s,%s", pkFeild, configParam.getSeekFieldName() + ",taskid");
        HashMap<Long, Long> pks = new HashMap<Long, Long>(2000);
        HashSet<Long> taskIds = new HashSet<Long>(2000);
        int i = 0;
        Date startingDate = (Date)configParam.getParams().get("startingDate");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"TaskJobRecordCleaner.executeEverySegment", (String)configParam.getMainEntityNumber(), (String)selectFieldStr, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys, (int)everytimeCount);){
            Row row = null;
            while (dataSet != null && dataSet.hasNext()) {
                ++i;
                row = dataSet.next();
                Long taskId = row.getLong("taskid");
                pks.put(row.getLong(pkFeild), taskId);
                taskIds.add(taskId);
                startingDate = seekDate = row.getDate(configParam.getSeekFieldName());
                if (i % 2000 != 0) continue;
                this.disposePartData(pkFeild, pks, taskIds, configParam);
                pks.clear();
            }
            if (row == null) {
                seekDate = endingDate;
            }
            if (i % 2000 > 0) {
                this.disposePartData(pkFeild, pks, taskIds, configParam);
            }
        }
        configParam.getParams().put("startingDate", startingDate);
        configParam.getParams().put("seekDate", seekDate);
        log.debug(String.format("\u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u5206\u6279\u6b21\u6e05\u7406\uff0c\u672c\u6279\u6b21\u5171\u6e05\u7406[%s]\u6761\u6570\u636e", configParam.getMainEntityNumber(), i));
        return i;
    }

    private void disposePartData(String pkFeild, Map<Long, Long> pks, Set<Long> taskIds, CleanTaskConfigParam configParam) {
        if (pks.size() <= 0) {
            return;
        }
        ArrayList<Long> newTaskIds = new ArrayList<Long>(taskIds.size());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"TaskJobRecordCleaner.disposePartData", (String)"wf_task", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds)}, (String)"id asc");
        Object object = null;
        try {
            Object var8_8 = null;
            while (dataSet != null && dataSet.hasNext()) {
                Row row = dataSet.next();
                newTaskIds.add(row.getLong("id"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<Object> pkIds = new ArrayList<Object>(pks.size());
        for (Map.Entry entry : pks.entrySet()) {
            if (newTaskIds.size() != 0 && newTaskIds.contains(entry.getValue())) continue;
            pkIds.add(entry.getKey());
        }
        this.disposeMainEntityData(pkFeild, pkIds, configParam);
    }
}

