/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.cleaner;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.cleaner.ProcessCleaner;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.FailedJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntityManager;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;

public class TimerJobCleaner
implements ProcessCleaner {
    private Log log = LogFactory.getLog(TimerJobCleaner.class);

    @Override
    public void execute(CommandContext commandContext, CleanTaskConfigParam configParam, List<String> businessKeys, List<Long> procInstIds) {
        if (WfUtils.isNotEmptyForCollection(businessKeys)) {
            return;
        }
        TimerJobEntityManager timerJobManager = commandContext.getTimerJobEntityManager();
        FailedJobEntityManager failedJobManager = commandContext.getFailedJobEntityManager();
        ArrayList<String> businessKeyList = new ArrayList<String>(businessKeys.size());
        for (String businessKey : businessKeys) {
            businessKeyList.add(String.format("'%s'", businessKey));
        }
        ArrayList<Object> params = new ArrayList<Object>(1000);
        for (int i = 0; i < businessKeyList.size(); ++i) {
            params.add(businessKeyList.get(i));
            if ((i + 1) % 1000 != 0) continue;
            this.deletePartTimerJobs(timerJobManager, failedJobManager, params);
            params.clear();
        }
        if (WfUtils.isNotEmptyForCollection(params)) {
            this.deletePartTimerJobs(timerJobManager, failedJobManager, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePartTimerJobs(TimerJobEntityManager timerJobManager, FailedJobEntityManager failedJobManager, List<Object> businessKeys) {
        List<String> params = WfUtils.formatInQueryParam(businessKeys, 200, false);
        String fields = "FID, FBUSINESSKEY, FEXECUTIONID, FPROCESSINSTANCEID, FPROCDEFID, FELEMENTID, FOPERATION, FENTITYNUMBER, FTYPE, FHANDLERTYPE, FHANDLERCFG, FROOTTRACENO, FEXCEPTIONMSG, FCREATEDATE, FBIZTRACENO";
        String sql = "SELECT " + fields + " FROM T_WF_TIMERJOB WHERE FBUSINESSKEY in ";
        try (TXHandle handle = TX.requiresNew();
             DataSet ds = WfUtils.batchQueryByIn(sql, params, "wf.engine.deleteFinishedProcessTimerJobs", true);){
            Iterator iter = ds.iterator();
            Long jobId = null;
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                jobId = row.getLong("FID");
                if (RuntimeUtil.isNeedToRemoveFailedJob(row.getString("FHANDLERTYPE"), row.getString("FHANDLERCFG"))) {
                    failedJobManager.createFailedJobByTimerJob(row);
                }
                timerJobManager.delete(jobId);
            }
            this.log.debug(String.format("deleteClosedJob_deleteTimerJobs\uff0c\u5220\u9664\u5e76\u5c06timerJob\u8868\u4e2d\u7684\u6570\u636e\u79fb\u52a8\u5230failedJob\u4e2d\u6267\u884c\u6210\u529f\uff01\u6570\u636e\u91cf[%s]", params.size()));
        }
    }
}

