/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.cleaner;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.impl.clean.cleaner.ProcessCleaner;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.CollectionUtil;

public class WeLinkToDoCleaner
implements ProcessCleaner {
    private static final String RESULT = "result";
    private Log log = LogFactory.getLog(WeLinkToDoCleaner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandContext commandContext, CleanTaskConfigParam configParam, List<String> businessKeys, List<Long> procInstIds) {
        int size;
        if (!WfConfigurationUtil.isEnabled("welink")) {
            return;
        }
        TXHandle handle = TX.requiresNew();
        String selectProperties = "id,taskid,procinstid,userid,openid,state,result,retries,corpid,appid,appname,appsecret,modifydate";
        int idsTotal = procInstIds.size();
        int pages = idsTotal % (size = 50) == 0 ? idsTotal / size : idsTotal / size + 1;
        try {
            for (int j = 0; j < pages; ++j) {
                QFilter f3;
                QFilter f2;
                QFilter f4;
                int endIndex = (j + 1) * size > idsTotal ? idsTotal : (j + 1) * size;
                QFilter f1 = new QFilter("procinstid", "in", procInstIds.subList(j * size, endIndex));
                DynamicObject[] targetWelink = BusinessDataServiceHelper.load((String)"msg_welinktodo", (String)selectProperties, (QFilter[])new QFilter[]{f1, f4 = (f2 = new QFilter(RESULT, "=", (Object)"true")).or(f3 = new QFilter(RESULT, "=", (Object)"false").and("retries", "=", (Object)6))});
                if (targetWelink == null || targetWelink.length <= 0) continue;
                ArrayList<Long> successIds = new ArrayList<Long>(targetWelink.length);
                ArrayList<DynamicObject> failJobs = new ArrayList<DynamicObject>(targetWelink.length);
                for (DynamicObject wl : targetWelink) {
                    if (wl.getString(RESULT).equals("false")) {
                        DynamicObject failJob = BusinessDataServiceHelper.newDynamicObject((String)"wf_failedjob");
                        JSONObject config = this.wrapConfig(wl, selectProperties);
                        failJob.set("jobhandlerconfiguration", (Object)config.toJSONString());
                        failJob.set("processinstanceid", (Object)wl.getLong("procinstid"));
                        failJob.set("channeltype", (Object)"welink");
                        failJob.set("createdate", (Object)new Date());
                        failJobs.add(failJob);
                    }
                    successIds.add(wl.getLong("id"));
                }
                if (CollectionUtil.isNotEmpty(successIds)) {
                    DeleteServiceHelper.delete((String)"msg_welinktodo", (QFilter[])new QFilter[]{new QFilter("id", "in", successIds)});
                }
                if (!CollectionUtil.isNotEmpty(failJobs)) continue;
                SaveServiceHelper.save((DynamicObject[])failJobs.toArray(new DynamicObject[0]));
            }
            this.log.debug(String.format("deleteClosedJob_moveWeLinkTodoDataToFailJob\uff0c\u6267\u884c\u6210\u529f\uff01\u6570\u636e\u91cf[%s]", procInstIds.size()));
        }
        catch (Exception e) {
            handle.markRollback();
            this.log.warn("\u4efb\u52a1\u8c03\u5ea6\u8fc1\u79fbwelinktodo\u6570\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            handle.close();
        }
    }

    private JSONObject wrapConfig(DynamicObject wl, String fields) {
        JSONObject config = new JSONObject();
        String[] fieldArray = fields.split(",");
        for (int i = 0; i < fieldArray.length; ++i) {
            String field = fieldArray[i];
            config.put(field, (Object)wl.getString(field));
        }
        return config;
    }
}

