/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.BecSystemParamterUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;
import kd.bos.workflow.engine.impl.clean.model.RelaCleanConfigParam;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;

public class CleanConfigFactory {
    private static Log log = LogFactory.getLog(CleanConfigFactory.class);
    private static final String VALUE_MODE_PEOCESS = "process";
    private static final String VALUE_MODE_TIMING = "timing";
    private static final String VALUE_MOMENT_IMMEDIATE = "immediate";
    private static final String VALUE_MOMENT_RETENTION = "retention";
    private static final String VALUE_MOMENT_ALL = "all";
    private static final String VALUE_DISPOSALTYPE_DELETE = "delete";
    private static final String VALUE_DISPOSAL_TRANSFER = "transfer";
    private static final String VALUE_DISPOSALTYPE_COMPACT = "compact";
    private static final String VALUE_BUSINESSKEY = "businessKey";
    private static final String VALUE_PROCESSINSTANCEID = "processInstanceId";
    private static final String YYYYMMDD = "yyyyMMdd";
    private static final String YYYYMM = "yyyyMM";
    private static final String YYYYMMDDHHMM = "yyyyMMddHHmm";
    private static final String WF_MESSAGE = "wf_message";
    private static final String WF_EVT = "wf_evt";
    private static final String WF_DEVOPS = "wf_devops";
    private static final String WFS_COMPACT = "wfs_compact";

    private CleanConfigFactory() {
    }

    public static List<CleanTaskConfigParam> getCleanTaskConfigParams(String appName, String cleanMoment) {
        ArrayList<CleanTaskConfigParam> allConfigParams = new ArrayList<CleanTaskConfigParam>(10);
        if (WfUtils.isEmpty(appName)) {
            return allConfigParams;
        }
        String cleanMode = VALUE_MODE_TIMING;
        switch (appName) {
            case "wfs": {
                cleanMode = VALUE_MODE_PEOCESS;
                if (WfUtils.isEmpty(cleanMoment)) {
                    return allConfigParams;
                }
                CleanConfigFactory.initWfsConfig(allConfigParams);
                break;
            }
            case "wfs_compact": {
                CleanConfigFactory.initWfsCompactConfig(allConfigParams);
                break;
            }
            case "wf_evt": {
                CleanConfigFactory.initWfEvtConfig(allConfigParams);
                break;
            }
            case "wf_devops": {
                CleanConfigFactory.initWfdevopsConfig(allConfigParams);
                break;
            }
            case "wf_message": {
                CleanConfigFactory.initMessageConfig(allConfigParams);
                break;
            }
        }
        if (WfUtils.isEmptyForCollection(allConfigParams)) {
            return allConfigParams;
        }
        List<CleanTaskConfigParam> result = CleanConfigFactory.mateDynamicConfig(allConfigParams, cleanMode, cleanMoment);
        CleanConfigFactory.writeResultToLog(appName, cleanMoment, result);
        return result;
    }

    private static void writeResultToLog(String appName, String cleanMoment, List<CleanTaskConfigParam> result) {
        StringBuilder logStr = new StringBuilder();
        for (CleanTaskConfigParam configParam : result) {
            logStr.append(configParam.getMainEntityNumber());
            if (!WfUtils.isEmptyForCollection(configParam.getRelaCleanConfigParams())) {
                logStr.append("[");
                for (RelaCleanConfigParam relaParam : configParam.getRelaCleanConfigParams()) {
                    logStr.append(relaParam.getRelaEntityNumber()).append(",");
                }
                logStr.setCharAt(logStr.length() - 1, ']');
            }
            logStr.append(",");
        }
        log.debug(String.format("\u6e05\u7406\u6846\u67b6\u51c6\u5907\u6e05\u7406\u5b9e\u4f53\u5b8c\u6210--\u6240\u5c5e\u5e94\u7528[%s]-\u6e05\u7406\u65f6\u673a[%s]-\u6e05\u7406\u5b9e\u4f53[%s]", appName, cleanMoment, logStr.length() > 0 ? logStr.substring(0, logStr.length() - 1) : ""));
    }

    private static List<CleanTaskConfigParam> mateDynamicConfig(List<CleanTaskConfigParam> allConfigParams, String cleanMode, String cleanMoment) {
        ArrayList<CleanTaskConfigParam> result = new ArrayList<CleanTaskConfigParam>(allConfigParams.size());
        if (WfUtils.isEmpty(cleanMode) || VALUE_MODE_PEOCESS.equals(cleanMode) && WfUtils.isEmpty(cleanMoment)) {
            return result;
        }
        HashSet<String> entityNumbers = new HashSet<String>(allConfigParams.size());
        for (CleanTaskConfigParam param : allConfigParams) {
            entityNumbers.add(param.getMainEntityNumber());
        }
        String selectFields = "entitynumber,cleanmoment,retentiontime,limitquantity,steplimitquantity,disposaltype,steplength,params,status,order";
        QFilter[] filters = new QFilter[]{new QFilter("entitynumber", "in", entityNumbers), new QFilter("cleanmode", "=", (Object)cleanMode)};
        DynamicObjectCollection dynConfigs = QueryServiceHelper.query((String)"wf_cleandynamicconfig", (String)selectFields, (QFilter[])filters);
        if (WfUtils.isEmptyForCollection((Collection)dynConfigs)) {
            for (CleanTaskConfigParam param : allConfigParams) {
                CleanConfigFactory.disposeNotHaveDynamicConfig(cleanMode, cleanMoment, param, result);
            }
            return result;
        }
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(entityNumbers.size());
        for (DynamicObject dyn : dynConfigs) {
            map.put(dyn.getString("entitynumber") + dyn.getInt("order"), dyn);
        }
        for (CleanTaskConfigParam param : allConfigParams) {
            String entityNumber = param.getMainEntityNumber();
            DynamicObject dyn = (DynamicObject)map.get(entityNumber + param.getOrder());
            if (dyn == null) {
                CleanConfigFactory.disposeNotHaveDynamicConfig(cleanMode, cleanMoment, param, result);
                continue;
            }
            if ("0".equals(dyn.getString("status"))) {
                log.debug(String.format("\u6e05\u7406\u6846\u67b6-\u4e3b\u5b9e\u4f53\uff1a[%s]\uff0c\u5728\u52a8\u6001\u6e05\u7406\u914d\u7f6e\u5217\u8868\u914d\u7f6e\u4e86\u7981\u7528\uff0c\u5c06\u4e0d\u4f1a\u6267\u884c\u6e05\u7406\u64cd\u4f5c\u3002", param.getMainEntityNumber()));
                continue;
            }
            String paramsJson = dyn.getString("params");
            Map paramMap = null;
            paramMap = WfUtils.isEmpty(paramsJson) ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)paramsJson, Map.class);
            param.setParams(paramMap);
            if (VALUE_MODE_PEOCESS.equals(cleanMode)) {
                param.setCleanMoment(dyn.getString("cleanmoment"));
                if (!cleanMoment.equals(param.getCleanMoment()) && !VALUE_MOMENT_ALL.equals(param.getCleanMoment())) continue;
                result.add(param);
                continue;
            }
            if (dyn.getInt("retentiontime") > 0) {
                param.setRetentionTime(dyn.getInt("retentiontime"));
            }
            if (dyn.getInt("limitquantity") > 0) {
                param.setLimitQuantity(dyn.getInt("limitquantity"));
            }
            if (dyn.getInt("steplimitquantity") > 0) {
                param.setStepLimitQuantity(dyn.getInt("steplimitquantity"));
            }
            if (dyn.getInt("steplength") > 0) {
                param.setStepLength(dyn.getInt("steplength"));
            }
            if (WfUtils.isNotEmpty(dyn.getString("disposaltype"))) {
                param.setDisposalType(dyn.getString("disposaltype"));
            }
            result.add(param);
        }
        return result;
    }

    private static void disposeNotHaveDynamicConfig(String cleanMode, String cleanMoment, CleanTaskConfigParam param, List<CleanTaskConfigParam> result) {
        if (VALUE_MODE_PEOCESS.equals(cleanMode)) {
            if (cleanMoment.equals(param.getCleanMoment()) || VALUE_MOMENT_ALL.equals(param.getCleanMoment())) {
                result.add(param);
            }
        } else {
            result.add(param);
        }
    }

    private static void initWfdevopsConfig(List<CleanTaskConfigParam> configParams) {
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_DEVOPS, "wf_devopsindicator", "createDate", new QFilter("sendtimes", ">=", (Object)4), null, new Object[]{3, 50000, 10000, 10, "t_wf_devopsindicator", true, false, 0}, null));
        int days = WfConfigurationUtil.getDevopsIndicatorRetentionDays();
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_DEVOPS, "wf_devopsindicator", "createDate", null, null, new Object[]{days, 50000, 10000, 10, "t_wf_devopsindicator", true, false, 1}, null));
        Calendar threeMonthscalendar = Calendar.getInstance();
        threeMonthscalendar.setTime(WfUtils.now());
        threeMonthscalendar.add(2, -3);
        String threeMonthscDateStr = new SimpleDateFormat(YYYYMMDD).format(threeMonthscalendar.getTime());
        QFilter threeMonthsFilter = new QFilter("number", "in", (Object)new String[]{"becAsyncMessageDaily", "becInstanceDaily", "bizProcessInstanceDaily", "expectionProcessDaily", "processInstanceDaily", "taskDaily", "asyncMessageDaily"}).and(new QFilter("type", "<", (Object)threeMonthscDateStr));
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_DEVOPS, "wf_opbehaviorcollect", "createDate", threeMonthsFilter, null, new Object[]{93, 5000, 1000, 10, "t_wf_behaviorcollect", true, false, 0}, null));
        Calendar yearCalendar = Calendar.getInstance();
        yearCalendar.setTime(WfUtils.now());
        yearCalendar.add(1, -1);
        String yearDateStr = new SimpleDateFormat(YYYYMM).format(yearCalendar.getTime());
        QFilter yearFilter = new QFilter("number", "in", (Object)new String[]{"becAsyncMessageMonthily", "bizProcessInstanceMonthly", "processInstanceMonthily", "taskMonthily", "asyncMessageMonthily"}).and(new QFilter("type", "<", (Object)yearDateStr));
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_DEVOPS, "wf_opbehaviorcollect", "createDate", yearFilter, null, new Object[]{366, 10, 10, 30, "t_wf_behaviorcollect", true, false, 1}, null));
        Calendar hourCalendar = Calendar.getInstance();
        hourCalendar.setTime(WfUtils.now());
        hourCalendar.add(10, -1);
        String hourDateStr = new SimpleDateFormat(YYYYMMDDHHMM).format(hourCalendar.getTime());
        QFilter hourFilter = new QFilter("number", "in", (Object)new String[]{"becAsyncMessageMinutelyConsumer", "becAsyncMessageMinutelySend", "asyncMessageMinutelyConsumer", "asyncMessageMinutelySend"}).and(new QFilter("type", "<", (Object)hourDateStr));
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_DEVOPS, "wf_opbehaviorcollect", "createDate", hourFilter, null, new Object[]{1, 5000, 1000, 10, "t_wf_behaviorcollect", true, false, 2}, null));
        Calendar monthscalendar = Calendar.getInstance();
        monthscalendar.setTime(WfUtils.now());
        monthscalendar.add(2, -1);
        String monthscDateStr = new SimpleDateFormat(YYYYMMDD).format(monthscalendar.getTime());
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_DEVOPS, "wf_evtinstance_statistics", "createDate", new QFilter("number", "<", (Object)monthscDateStr), null, new Object[]{32, 5000, 1000, 10, "t_wf_evtinstancecollect", false, false}, null));
        Calendar oneMonthCalendar = Calendar.getInstance();
        oneMonthCalendar.setTime(WfUtils.now());
        oneMonthCalendar.add(2, -1);
        Date queryMonthCalendar = oneMonthCalendar.getTime();
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_DEVOPS, "wf_pluginexedetail", "begintime", new QFilter("begintime", "<", (Object)queryMonthCalendar), "kd.bos.workflow.engine.impl.clean.cleaner.PluginExeRecordCleaner", new Object[]{31, 5000, 20000, 10, "t_wf_pluginexedetail", false, false}, null));
    }

    private static void initWfEvtConfig(List<CleanTaskConfigParam> configParams) {
        ArrayList<String> stateList = new ArrayList<String>(3);
        stateList.add(JobStateEnum.COMPLETED.getNumber());
        stateList.add(JobStateEnum.ERRORED.getNumber());
        QFilter jobQFilter = new QFilter("state", "in", stateList);
        ArrayList<RelaCleanConfigParam> relaCleanConfigParams = new ArrayList<RelaCleanConfigParam>(1);
        RelaCleanConfigParam relaParam = new RelaCleanConfigParam();
        relaParam.setRelaEntityNumber("evt_log");
        relaParam.setRelaField("jobid");
        relaParam.setMultiLang(false);
        relaParam.setTableName("t_evt_log");
        relaParam.setLogForm(false);
        relaCleanConfigParams.add(relaParam);
        RelaCleanConfigParam relaParam2 = new RelaCleanConfigParam();
        relaParam2.setRelaEntityNumber("evt_loges");
        relaParam2.setRelaField("jobid");
        relaParam2.setTableName("t_evt_jobrecordlog");
        relaParam2.setMultiLang(false);
        relaParam2.setLogForm(true);
        relaCleanConfigParams.add(relaParam2);
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_EVT, "evt_job", "createDate", jobQFilter, null, new Object[]{BecSystemParamterUtils.getRetentionTime(), 5000000, 50000, 3, "t_evt_jobrecord", false, false}, relaCleanConfigParams));
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_EVT, "evt_hijob", "createDate", jobQFilter, null, new Object[]{BecSystemParamterUtils.getRetentionTime(), 5000000, 50000, 3, "t_evt_hijobrecord", false, false}, relaCleanConfigParams));
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_EVT, "evt_log", "createDate", null, "kd.bos.workflow.engine.impl.clean.cleaner.EvtLogCleaner", new Object[]{0, 2000000, 50000, 3, null, false, false}, null));
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_EVT, "evt_deadletterjob", "createDate", null, null, new Object[]{366, 5000000, 50000, 3, "t_evt_deadletterjob", false, false}, null));
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_EVT, "evt_abnormalinstance", "createDate", null, null, new Object[]{366, 5000000, 50000, 3, "t_evt_abnormalinstance", false, false}, null));
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_EVT, "evt_hiabnormalsubs", "createDate", null, null, new Object[]{183, 5000000, 50000, 3, "t_evt_hiabnormalsubs", true, false}, null));
    }

    private static void initMessageConfig(List<CleanTaskConfigParam> configParams) {
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_MESSAGE, "wf_msg_hifailmessage", "deletedate", null, "", new Object[]{30, 200000, 50000, 3, "t_wf_himsgfail", true, false}, null));
        ArrayList<RelaCleanConfigParam> relaCleanConfigParams = new ArrayList<RelaCleanConfigParam>(1);
        RelaCleanConfigParam relaParam = new RelaCleanConfigParam();
        relaParam.setRelaEntityNumber("wf_msg_himessage");
        relaParam.setRelaField("id");
        relaParam.setMultiLang(true);
        relaParam.setTableName("t_wf_himessage");
        relaParam.setLogForm(false);
        relaCleanConfigParams.add(relaParam);
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_MESSAGE, "wf_msg_hireceiver", "deletedate", null, "kd.bos.workflow.message.service.schedule.ClearHiMessageDataTask", new Object[]{30, 200000, 50000, 3, "t_wf_himsgreceiver", true, false}, relaCleanConfigParams));
        ArrayList<RelaCleanConfigParam> channelParams = new ArrayList<RelaCleanConfigParam>(1);
        QFilter channelFilter = new QFilter("todostate", "in", (Object)new String[]{"UNTREATED", "DEALSUCCESS"});
        RelaCleanConfigParam channelParam = new RelaCleanConfigParam();
        channelParam.setRelaEntityNumber("wf_taskjobretrylog");
        channelParam.setRelaField("channellogid");
        channelParam.setMultiLang(true);
        channelParam.setTableName("t_wf_taskjobretrylog");
        channelParam.setLogForm(false);
        channelParams.add(channelParam);
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_MESSAGE, "wf_taskjob", "createDate", channelFilter, null, new Object[]{30, 200000, 50000, 7, "t_wf_taskjob", true, false, 0}, channelParams));
        ArrayList<RelaCleanConfigParam> channelFailParams = new ArrayList<RelaCleanConfigParam>(1);
        QFilter channelFailFilter = new QFilter("todostate", "=", (Object)"DEALFAIL");
        RelaCleanConfigParam channelFailParam = new RelaCleanConfigParam();
        channelFailParam.setRelaEntityNumber("wf_taskjobretrylog");
        channelFailParam.setRelaField("channellogid");
        channelFailParam.setMultiLang(true);
        channelFailParam.setTableName("t_wf_taskjobretrylog");
        channelFailParam.setLogForm(false);
        channelFailParam.setRelaTransferEntity("wf_hitaskjobretrylog");
        channelFailParams.add(channelFailParam);
        CleanTaskConfigParam param = CleanConfigFactory.initTimingDeleteConfig(WF_MESSAGE, "wf_taskjob", "createDate", channelFailFilter, null, new Object[]{90, 200000, 50000, 7, "t_wf_taskjob", true, false, 1}, channelFailParams);
        configParams.add(param);
        ArrayList<String> params = new ArrayList<String>();
        params.add("errored");
        params.add("completed");
        CleanTaskConfigParam taskJobRecordParam = CleanConfigFactory.initTimingTransferConfig(WF_MESSAGE, "wf_taskjobrecord", "createdate", new QFilter("state", "in", params), "kd.bos.workflow.engine.impl.clean.cleaner.TaskJobRecordCleaner", new Object[]{1, 200000, 50000, 3, "t_wf_taskjobrecord", false, false, 1, "wf_hitaskjobrecord"}, channelFailParams);
        if (taskJobRecordParam != null) {
            configParams.add(taskJobRecordParam);
        }
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_MESSAGE, "wf_hitaskjobrecord", "createDate", null, "", new Object[]{15, 200000, 50000, 3, "t_wf_hitaskjobrecord", false, false}, null));
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WF_MESSAGE, "msg_duplicatelog", "duplicatedate", null, "", new Object[]{7, 200000, 50000, 3, "t_wf_duplicatelog", true, false}, null));
    }

    private static void initWfsConfig(List<CleanTaskConfigParam> configParams) {
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_RETENTION, "wf_eventlogentry", VALUE_BUSINESSKEY, null, null, new Object[]{"t_wf_evtlog", false, false}));
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_ALL, "wf_eventlogentryes", VALUE_BUSINESSKEY, null, null, new Object[]{"t_wf_processjoblog", false, true}));
        ArrayList<String> stateList = new ArrayList<String>(3);
        stateList.add(JobStateEnum.COMPLETED.getNumber());
        stateList.add(JobStateEnum.ERRORED.getNumber());
        QFilter jobQFilter = new QFilter("state", "in", stateList);
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_RETENTION, "wf_job", VALUE_PROCESSINSTANCEID, jobQFilter, null, new Object[]{"t_wf_jobrecord", false, false}));
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_RETENTION, "wf_historicjobrecord", VALUE_BUSINESSKEY, null, null, new Object[]{"t_wf_hijobrecord", false, false}));
        String keepFields = WfConfigurationUtil.getKeepFieldsInVariable();
        if (WfUtils.isNotEmpty(keepFields)) {
            List<String> keepFieldList = Arrays.asList(keepFields.split(","));
            QFilter hivarinstQFilter = new QFilter("name", "not in", keepFieldList);
            configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_ALL, "wf_hivarinst", VALUE_PROCESSINSTANCEID, hivarinstQFilter, null, new Object[]{"t_wf_hivarinst", false, false}));
        } else {
            configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_ALL, "wf_hivarinst", VALUE_PROCESSINSTANCEID, null, null, new Object[]{"t_wf_hivarinst", false, false}));
        }
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_IMMEDIATE, "wf_precomputorinstance", VALUE_PROCESSINSTANCEID, null, null, new Object[]{"t_wf_precomputorinstance", true, false}));
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_ALL, "wf_hiuseractinst", VALUE_PROCESSINSTANCEID, null, null, new Object[]{"t_wf_hiuseractinst", true, false}));
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_RETENTION, "wf_hiconditioninst", VALUE_BUSINESSKEY, null, null, new Object[]{"t_wf_hiconditioninst", false, false}));
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_RETENTION, "wf_runtimeparselog", VALUE_BUSINESSKEY, null, null, new Object[]{"t_wf_runtimeparselog", false, true}));
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_RETENTION, "wf_conditionparselog", VALUE_BUSINESSKEY, null, null, new Object[]{"t_wf_condruleparselog", false, true}));
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_RETENTION, "wf_idempotent", VALUE_PROCESSINSTANCEID, null, null, new Object[]{"t_wf_idempotent", false, false}));
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_RETENTION, "msg_yzjtodo", VALUE_PROCESSINSTANCEID, null, null, new Object[]{"t_wf_yzjtodo", true, false}));
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_RETENTION, "wf_taskhandlelog", VALUE_PROCESSINSTANCEID, null, null, new Object[]{"t_wf_taskhandlelog", true, false}));
        QFilter hiparticipantQFilter = new QFilter("taskId", "=", (Object)0L);
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_RETENTION, "wf_hiparticipant", VALUE_PROCESSINSTANCEID, hiparticipantQFilter, null, new Object[]{"t_wf_hiparticipant", true, false}));
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_RETENTION, "wf_deadletterjob", VALUE_PROCESSINSTANCEID, null, "kd.bos.workflow.engine.impl.clean.cleaner.DeadLetterJobCleaner", new Object[]{"t_wf_deadletterjob", true, false}));
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_RETENTION, "msg_welinktodo", VALUE_PROCESSINSTANCEID, null, "kd.bos.workflow.engine.impl.clean.cleaner.WeLinkToDoCleaner", new Object[]{"t_msg_welinktodo", false, false}));
        configParams.add(CleanConfigFactory.initProcessDeleteConfig(VALUE_MOMENT_RETENTION, "wf_timerjob", VALUE_BUSINESSKEY, null, "kd.bos.workflow.engine.impl.clean.cleaner.TimerJobCleaner", new Object[]{"t_wf_timerjob", false, false}));
        CleanConfigFactory.initWfsCompactConfig(configParams);
    }

    private static void initWfsCompactConfig(List<CleanTaskConfigParam> configParams) {
        QFilter auditFlowFilter = new QFilter("processtype", "=", (Object)ProcessType.AuditFlow.name());
        configParams.add(CleanConfigFactory.initTimingCompactConfig(WFS_COMPACT, "wf_hiactinst", null, auditFlowFilter, null, new Object[]{30, 20000, 5000, 7, "t_wf_hiactinst", true, false, 0}, null));
        configParams.add(CleanConfigFactory.initTimingCompactConfig(WFS_COMPACT, "wf_operationlog", null, auditFlowFilter, null, new Object[]{180, 20000, 5000, 7, "t_wf_operationlog", true, false, 0}, null));
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            configParams.add(CleanConfigFactory.initTimingCompactConfig(WFS_COMPACT, "wf_hiparticipant", null, auditFlowFilter, null, new Object[]{30, 20000, 5000, 7, "t_wf_hiparticipant", true, false, 1}, null));
        }
        QFilter bizFlowFilter = new QFilter("processtype", "=", (Object)ProcessType.BizFlow.name());
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WFS_COMPACT, "wf_hiactinst", null, bizFlowFilter, null, new Object[]{30, 20000, 5000, 7, "t_wf_hiactinst", true, false, 1}, null));
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WFS_COMPACT, "wf_operationlog", null, bizFlowFilter, null, new Object[]{30, 20000, 5000, 7, "t_wf_operationlog", true, false, 1}, null));
        configParams.add(CleanConfigFactory.initTimingDeleteConfig(WFS_COMPACT, "wf_hiparticipant", null, bizFlowFilter, null, new Object[]{30, 20000, 5000, 7, "t_wf_hiparticipant", true, false, 2}, null));
    }

    private static CleanTaskConfigParam initProcessDeleteConfig(String cleanMoment, String mainEntityNumber, String cleanIndex, QFilter conditionFilters, String executePlugin, Object[] para) {
        CleanTaskConfigParam config = new CleanTaskConfigParam();
        config.setAppName("wfs");
        config.setCleanMode(VALUE_MODE_PEOCESS);
        config.setDisposalType(VALUE_DISPOSALTYPE_DELETE);
        config.setCleanMoment(cleanMoment);
        config.setCleanIndex(cleanIndex);
        config.setMainEntityNumber(mainEntityNumber);
        config.setConditionFilters(conditionFilters);
        config.setExecutePlugin(executePlugin);
        config.setTableName((String)para[0]);
        config.setMultiLang((Boolean)para[1]);
        config.setLogForm((Boolean)para[2]);
        config.setOrder(0);
        return config;
    }

    private static CleanTaskConfigParam initTimingDeleteConfig(String appName, String mainEntityNumber, String seekFieldName, QFilter conditionFilters, String executePlugin, Object[] para, List<RelaCleanConfigParam> relaCleanConfigParams) {
        CleanTaskConfigParam config = CleanConfigFactory.initTimingConfig(appName, mainEntityNumber, seekFieldName, conditionFilters, executePlugin, para, relaCleanConfigParams);
        config.setDisposalType(VALUE_DISPOSALTYPE_DELETE);
        return config;
    }

    private static CleanTaskConfigParam initTimingTransferConfig(String appName, String mainEntityNumber, String seekFieldName, QFilter conditionFilters, String executePlugin, Object[] para, List<RelaCleanConfigParam> relaCleanConfigParams) {
        CleanTaskConfigParam config = CleanConfigFactory.initTimingConfig(appName, mainEntityNumber, seekFieldName, conditionFilters, executePlugin, para, relaCleanConfigParams);
        config.setDisposalType(VALUE_DISPOSAL_TRANSFER);
        if (para.length == 9 && para[8] != null) {
            config.setTransferEntity((String)para[8]);
            return config;
        }
        return null;
    }

    private static CleanTaskConfigParam initTimingCompactConfig(String appName, String mainEntityNumber, String seekFieldName, QFilter conditionFilters, String executePlugin, Object[] para, List<RelaCleanConfigParam> relaCleanConfigParams) {
        CleanTaskConfigParam config = CleanConfigFactory.initTimingConfig(appName, mainEntityNumber, seekFieldName, conditionFilters, executePlugin, para, relaCleanConfigParams);
        config.setDisposalType(VALUE_DISPOSALTYPE_COMPACT);
        return config;
    }

    private static CleanTaskConfigParam initTimingConfig(String appName, String mainEntityNumber, String seekFieldName, QFilter conditionFilters, String executePlugin, Object[] para, List<RelaCleanConfigParam> relaCleanConfigParams) {
        CleanTaskConfigParam config = new CleanTaskConfigParam();
        config.setAppName(appName);
        config.setCleanMode(VALUE_MODE_TIMING);
        config.setMainEntityNumber(mainEntityNumber);
        config.setSeekFieldName(seekFieldName);
        config.setConditionFilters(conditionFilters);
        config.setRetentionTime((Integer)para[0]);
        config.setLimitQuantity((Integer)para[1]);
        config.setStepLimitQuantity((Integer)para[2]);
        config.setStepLength((Integer)para[3]);
        config.setRelaCleanConfigParams(relaCleanConfigParams);
        config.setExecutePlugin(executePlugin);
        config.setTableName((String)para[4]);
        config.setMultiLang((Boolean)para[5]);
        config.setLogForm((Boolean)para[6]);
        if (para.length > 7) {
            config.setOrder((Integer)para[7]);
        } else {
            config.setOrder(0);
        }
        return config;
    }
}

