/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.clean.transfer;

import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.transfer.DefaultEntityTransfer;
import kd.bos.workflow.engine.impl.clean.transfer.EntityTransfer;
import kd.bos.workflow.engine.impl.clean.transfer.InstanceEntityTransfer;
import kd.bos.workflow.engine.impl.clean.transfer.ProcInstEntityTransfer;
import kd.bos.workflow.engine.impl.clean.transfer.ProcessEntityTransfer;
import kd.bos.workflow.engine.impl.clean.transfer.TaskJobEntityTransfer;

public class EntityTransferFactory {
    private EntityTransferFactory() {
    }

    public static EntityTransfer createEntityTransfer(String sourceEntity, String targetEntity) {
        if (WfUtils.isEmpty(sourceEntity) || WfUtils.isEmpty(targetEntity)) {
            return null;
        }
        if ("wf_historicalprocesses".equals(sourceEntity)) {
            switch (targetEntity) {
                case "wf_taskhandlelog": 
                case "wf_hivarinst": 
                case "wf_hiparticipant": 
                case "wf_precomputorinstance": 
                case "wf_hiconditioninst": 
                case "wf_runtimeparselog": 
                case "wf_conditionparselog": 
                case "wf_job": 
                case "wf_hiactinst": {
                    return new DefaultEntityTransfer();
                }
                case "wf_idempotent": {
                    return new InstanceEntityTransfer();
                }
                case "msg_yzjtodo": 
                case "wf_operationlog": {
                    return new ProcInstEntityTransfer();
                }
            }
            return new ProcessEntityTransfer();
        }
        if ("wf_taskjobretrylog".equals(sourceEntity) || "wf_taskjob".equals(sourceEntity)) {
            return new TaskJobEntityTransfer();
        }
        return new DefaultEntityTransfer();
    }
}

