/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.AbstractSetProcessInstanceStateCmd;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.SuspensionState;
import kd.bos.workflow.engine.repository.ProcessDefinition;
import kd.bos.workflow.engine.runtime.ProcessInstance;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.exception.WFObjectNotFoundException;

public abstract class AbstractSetProcessDefinitionStateCmd
implements Command<List<ProcessDefinitionEntity>> {
    protected static Log logger = LogFactory.getLog(AbstractSetProcessDefinitionStateCmd.class);
    protected Long processDefinitionId;
    protected String processDefinitionKey;
    protected ProcessDefinitionEntity processDefinitionEntity;
    protected boolean includeProcessInstances = false;
    protected Date executionDate;

    public AbstractSetProcessDefinitionStateCmd(ProcessDefinitionEntity processDefinitionEntity, Date executionDate) {
        this.processDefinitionEntity = processDefinitionEntity;
        this.executionDate = executionDate;
    }

    public AbstractSetProcessDefinitionStateCmd(Long processDefinitionId, String processDefinitionKey, Date executionDate) {
        this.processDefinitionId = processDefinitionId;
        this.processDefinitionKey = processDefinitionKey;
        this.executionDate = executionDate;
    }

    @Override
    public List<ProcessDefinitionEntity> execute(CommandContext commandContext) {
        List<ProcessDefinitionEntity> processDefinitions = this.findProcessDefinition(commandContext);
        if (this.executionDate != null) {
            this.createTimerForDelayedExecution(commandContext, processDefinitions);
        } else {
            this.changeProcessDefinitionState(commandContext, processDefinitions);
        }
        return processDefinitions;
    }

    protected List<ProcessDefinitionEntity> findProcessDefinition(CommandContext commandContext) {
        if (this.processDefinitionEntity != null) {
            return Collections.singletonList(this.processDefinitionEntity);
        }
        if (this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new WFIllegalArgumentException("Process definition id or key cannot be null");
        }
        ArrayList<ProcessDefinitionEntity> processDefinitionEntities = new ArrayList<ProcessDefinitionEntity>();
        ProcessDefinitionEntityManager processDefinitionManager = commandContext.getProcessDefinitionEntityManager();
        if (this.processDefinitionId != null) {
            ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)processDefinitionManager.findById(this.processDefinitionId);
            if (processDefinitionEntity == null) {
                throw new WFObjectNotFoundException("Cannot find process definition for id '" + this.processDefinitionId + "'", ProcessDefinition.class);
            }
            processDefinitionEntities.add(processDefinitionEntity);
        } else {
            EntityQueryBuilder qb = processDefinitionManager.createQueryBuilder().addFilter("key", this.processDefinitionKey);
            List processDefinitions = processDefinitionManager.findByQueryBuilder(qb);
            if (processDefinitions.isEmpty()) {
                throw new WFEngineException("Cannot find process definition for key '" + this.processDefinitionKey + "'");
            }
            for (ProcessDefinition processDefinition : processDefinitions) {
                processDefinitionEntities.add((ProcessDefinitionEntity)processDefinition);
            }
        }
        return processDefinitionEntities;
    }

    protected void createTimerForDelayedExecution(CommandContext commandContext, List<ProcessDefinitionEntity> processDefinitions) {
        for (ProcessDefinitionEntity processDefinition : processDefinitions) {
            TimerJobEntity timer = (TimerJobEntity)commandContext.getTimerJobEntityManager().create();
            timer.setJobType("timer");
            timer.setProcessDefinitionId(processDefinition.getId());
            timer.setDuedate(this.executionDate);
            timer.setJobHandlerType(this.getDelayedExecutionJobHandlerType());
            commandContext.getJobManager().scheduleTimerJob(timer);
        }
    }

    protected void changeProcessDefinitionState(CommandContext commandContext, List<ProcessDefinitionEntity> processDefinitions) {
        for (final ProcessDefinitionEntity processDefinition : processDefinitions) {
            SuspensionState.SuspensionStateUtil.setSuspensionState(processDefinition, this.getProcessDefinitionSuspensionState());
            commandContext.addCloseListener(new DefaultCommandContextCloseListener("SuspensionState"){

                @Override
                public void closed(CommandContext commandContext) {
                    String appType = "wf";
                    if ("BizFlow".equals(processDefinition.getType())) {
                        appType = "bpm";
                    }
                    WfUtils.addOpLogByAppType(appType, "wf_processdefinition", "changeProcessDefinitionState", AbstractSetProcessDefinitionStateCmd.this.getOperationNameBridge(), new MultiLangEnumBridge("\u6d41\u7a0b\u5b9a\u4e49ID: %1$s \u7f16\u7801: %2$s \u7248\u672c: %3$s", "AbstractSetProcessDefinitionStateCmd_1", "bos-wf-engine"), processDefinition.getId(), processDefinition.getKey(), processDefinition.getVersion());
                }
            });
            String env = (String)commandContext.getAttribute("env");
            if (env != null && "publish".equalsIgnoreCase(env)) continue;
            commandContext.getProcessEngineConfiguration().getDeploymentManager().getProcessDefinitionCache().remove(processDefinition.getId());
            WfCacheHelper.updateProcessDefWhenStateChange(commandContext, processDefinition.getEntraBill(), null);
            boolean enable = "enable".equalsIgnoreCase(processDefinition.getEnable());
            commandContext.getProcessConfigEntityManager().updateProcessConfigEnableState(ModelType.BizFlow.name().equals(processDefinition.getType()), processDefinition.getId(), enable);
        }
    }

    protected abstract SuspensionState getProcessDefinitionSuspensionState();

    protected abstract String getOperationLogName();

    protected abstract MultiLangEnumBridge getOperationNameBridge();

    protected abstract String getDelayedExecutionJobHandlerType();

    protected abstract AbstractSetProcessInstanceStateCmd getProcessInstanceChangeStateCmd(ProcessInstance var1);
}

