/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.event.util.WaitEventUtil;
import kd.bos.workflow.engine.impl.asyncexecutor.JobManager;
import kd.bos.workflow.engine.impl.event.EventHandler;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;

public abstract class AbstractWaitEventReceivedCmd
implements Command<Void> {
    protected Log log = LogFactory.getLog(this.getClass());
    protected Long subscriptionId;
    protected String eventNumber;
    protected Long executionId;
    protected Map<String, Object> payload;
    protected boolean async;

    public AbstractWaitEventReceivedCmd(String eventNumber, Long executionId, Map<String, Object> payload, boolean async) {
        this.eventNumber = eventNumber;
        this.executionId = executionId;
        this.payload = payload;
        this.async = async;
    }

    public AbstractWaitEventReceivedCmd(Long subscriptionId, Map<String, Object> payload, boolean async) {
        this.subscriptionId = subscriptionId;
        this.payload = payload;
        this.async = async;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.async) {
            this.processEventAsync(commandContext);
        } else {
            this.log.debug(String.format("begin process waitEvent... %s", this.subscriptionId));
            EventSubscriptionEntity eventSubscriptionEntity = (EventSubscriptionEntity)commandContext.getEventSubscriptionEntityManager().findById(this.subscriptionId);
            this.processEventSync(commandContext, eventSubscriptionEntity);
        }
        return null;
    }

    protected void processEventAsync(CommandContext commandContext) {
        String businessKey = (String)this.payload.get("businessKey");
        this.log.debug("businessKey: " + businessKey);
        List<EventSubscriptionEntity> eventSubscriptionEntities = this.getEventSubscriptionEntities(commandContext);
        if (eventSubscriptionEntities == null || eventSubscriptionEntities.isEmpty()) {
            this.log.debug(String.format("Cann't find EventSubscriptionEntity! eventNumber: %s, executionId: %s", this.eventNumber, this.executionId));
        } else {
            this.log.debug("begin scheduleEvent...");
            this.scheduleMatchedEventsAsync(commandContext, eventSubscriptionEntities);
        }
    }

    protected void processEventSync(CommandContext commandContext, EventSubscriptionEntity eventSubscriptionEntity) {
        String type = eventSubscriptionEntity.getEventType();
        EventHandler eventHandler = commandContext.getProcessEngineConfiguration().getEventHandler(type);
        if (eventHandler != null) {
            eventHandler.handleEvent(eventSubscriptionEntity, this.payload, commandContext);
        } else {
            this.log.debug(String.format("the %s EventHandler is null!", type));
        }
    }

    protected List<EventSubscriptionEntity> getEventSubscriptionEntities(CommandContext commandContext) {
        if (WfUtils.isNotEmpty(this.executionId)) {
            return this.getProcessEventSubscriptionEntities(commandContext);
        }
        Long procInstanceId = (Long)this.payload.get("processInstanceId");
        return commandContext.getEventSubscriptionEntityManager().findEventSubscriptionsByNameAndProcessInstanceId("waitevent", this.eventNumber, procInstanceId);
    }

    protected void scheduleMatchedEventsAsync(CommandContext commandContext, List<EventSubscriptionEntity> eventSubscriptionEntities) {
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptionEntities) {
            if (!this.checkCondition(commandContext, eventSubscriptionEntity)) continue;
            this.scheduleEventAsync(commandContext, eventSubscriptionEntity);
        }
    }

    protected List<EventSubscriptionEntity> getProcessEventSubscriptionEntities(CommandContext commandContext) {
        List<EventSubscriptionEntity> entities = null;
        EventSubscriptionEntityManager manager = commandContext.getEventSubscriptionEntityManager();
        String scope = (String)this.payload.get("scope");
        if ("bizTraceNo".equals(scope)) {
            String bizTraceNo = (String)this.payload.get("biztraceno");
            entities = manager.findEventSubscriptionsByNameAndBizTraceNo(this.getWaitEventSubscriptionType(), this.eventNumber, bizTraceNo);
        } else {
            Long procInstanceId = (Long)this.payload.get("processInstanceId");
            entities = manager.findEventSubscriptionsByNameAndProcessInstanceId(this.getWaitEventSubscriptionType(), this.eventNumber, procInstanceId);
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkCondition(CommandContext commandContext, EventSubscriptionEntity entity) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(entity.getProcessDefinitionId(), entity.getProcessInstanceId());
        FlowElement element = bpmnModel.getFlowElement(entity.getActivityId());
        String event = this.getWaitEvent(element);
        if (event != null && event.equalsIgnoreCase(entity.getEventName())) {
            ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(entity.getExecutionId());
            String variableKey = WaitEventUtil.getEventParamsVariableKey(element.getId(), event);
            try {
                Object evtParams;
                Object params = this.payload.get("params");
                if (params != null) {
                    execution.setTransientVariable(variableKey, params);
                }
                if ((evtParams = this.payload.get("eventParams")) != null) {
                    execution.setTransientVariable("eventParams", evtParams);
                }
                ConditionalRuleEntity condition = this.getWaitCondition(element);
                String identify = "EVENT-WAIT-CONDITION";
                if (element instanceof WaitTask) {
                    identify = ConditionType.EVENT_WAIT_SKIP.getType();
                }
                if (element instanceof BillTask) {
                    identify = ConditionType.EVENT_BILL_SKIP.getType();
                }
                String key = ConditionUtil.getConInstKey(element.getId(), identify);
                if (condition == null) {
                    boolean bl = true;
                    return bl;
                }
                if (ConditionUtil.hasTrueCondition(condition, (VariableScope)execution, key)) {
                    boolean bl = true;
                    return bl;
                }
                this.log.debug(String.format("\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff01 Expression: %s  Plugin: %s", condition.getExpression(), condition.getPlugin()));
                boolean bl = false;
                return bl;
            }
            finally {
                execution.removeTransientVariable(variableKey);
                execution.removeTransientVariable("eventParams");
            }
        }
        return false;
    }

    protected void scheduleEventAsync(CommandContext commandContext, EventSubscriptionEntity eventSubscriptionEntity) {
        JobManager jobManager = commandContext.getJobManager();
        this.payload.put("subscriptionId", eventSubscriptionEntity.getId());
        this.payload.put("type", eventSubscriptionEntity.getEventType());
        JobEntity message = jobManager.createWaitEventJobByEventScription(eventSubscriptionEntity, this.payload);
        jobManager.scheduleAsyncJob(message);
    }

    protected abstract String getWaitEvent(FlowElement var1);

    protected abstract ConditionalRuleEntity getWaitCondition(FlowElement var1);

    protected abstract String getWaitEventSubscriptionType();
}

