/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.domain.model.NodeLifecycleUtil;
import kd.bos.workflow.engine.WFLicenseUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.AbstractSetProcessDefinitionStateCmd;
import kd.bos.workflow.engine.impl.cmd.AbstractSetProcessInstanceStateCmd;
import kd.bos.workflow.engine.impl.cmd.ActivateProcessInstanceCmd;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.management.InitProcessInfoEntityCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.SuspensionState;
import kd.bos.workflow.engine.runtime.ProcessInstance;

public class ActivateProcessDefinitionCmd
extends AbstractSetProcessDefinitionStateCmd {
    public ActivateProcessDefinitionCmd(ProcessDefinitionEntity processDefinitionEntity, Date executionDate) {
        super(processDefinitionEntity, executionDate);
    }

    public ActivateProcessDefinitionCmd(Long processDefinitionId, String processDefinitionKey, Date executionDate) {
        super(processDefinitionId, processDefinitionKey, executionDate);
    }

    @Override
    public List<ProcessDefinitionEntity> execute(CommandContext commandContext) {
        WFLicenseUtil.checkLicenseAllowCount(commandContext.getProcessDefinitionEntityManager().getEnableProcessCount(), Boolean.TRUE, Boolean.FALSE);
        Object result = super.execute(commandContext);
        Long procDefId = this.processDefinitionId;
        if (procDefId == null) {
            procDefId = this.processDefinitionEntity.getId();
        }
        this.initProcessInfoEntity(commandContext, procDefId);
        if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("processDefinitionId", procDefId);
            new EventTriggerCmd("wf.AfterActivateProcessEvent", SerializationUtils.toJsonString(params)).execute(commandContext);
        }
        final Long definitionId = procDefId;
        commandContext.addCloseListener(new DefaultCommandContextCloseListener("lifecycleListener"){

            @Override
            public void closed(CommandContext commandContext) {
                try {
                    NodeLifecycleUtil.executeLifecycleActivateListener(definitionId);
                }
                catch (Exception e) {
                    this.log.error(WfUtils.getExceptionStacktrace(e));
                }
            }
        });
        return result;
    }

    private void initProcessInfoEntity(CommandContext commandContext, Long procDefId) {
        try {
            boolean initialized = commandContext.getProcessInfoEntityManager().isInitialized(procDefId);
            if (!initialized) {
                new InitProcessInfoEntityCmd(procDefId).execute(commandContext);
            }
        }
        catch (Exception e) {
            logger.error(String.format("initProcessInfoEntity failed! %s %s", procDefId, WfUtils.getExceptionStacktrace(e)));
        }
    }

    @Override
    protected SuspensionState getProcessDefinitionSuspensionState() {
        return ManagementConstants.ACTIVE;
    }

    @Override
    protected String getDelayedExecutionJobHandlerType() {
        return null;
    }

    @Override
    protected String getOperationLogName() {
        return WFMultiLangConstants.getEnableProcessName();
    }

    @Override
    protected MultiLangEnumBridge getOperationNameBridge() {
        return WFMultiLangConstants.getEnableProcessBridgeName();
    }

    @Override
    protected AbstractSetProcessInstanceStateCmd getProcessInstanceChangeStateCmd(ProcessInstance processInstance) {
        return new ActivateProcessInstanceCmd(processInstance.getId());
    }
}

