/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.Date;
import java.util.List;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.AbstractSetProcessInstanceStateCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.management.SuspensionState;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DurationDetailEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DurationDetailEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class ActivateProcessInstanceCmd
extends AbstractSetProcessInstanceStateCmd {
    public ActivateProcessInstanceCmd(Long executionId) {
        super(executionId);
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntity entity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.processInstanceId);
        if (entity != null && entity.getSuspensionState().equals(this.getNewState().getStateCode())) {
            return null;
        }
        super.execute(commandContext);
        this.updateDurationDetail(commandContext);
        return null;
    }

    private void updateDurationDetail(CommandContext commandContext) {
        DurationDetailEntityManager durationDetailEntityManager = commandContext.getDurationDetailEntityManager();
        List<DurationDetailEntity> durationDetails = durationDetailEntityManager.getDurationDetailsByProcessInstanceId(this.processInstanceId);
        if (durationDetails != null && !durationDetails.isEmpty()) {
            for (DurationDetailEntity durationDetail : durationDetails) {
                if (durationDetail.getUndoSuspendTime() != null) continue;
                Date currentDate = WfUtils.now();
                durationDetail.setUndoSuspendTime(currentDate);
                Date suspendTime = durationDetail.getSuspendTime();
                if (suspendTime != null) {
                    Long newSuspendDuration = currentDate.getTime() - suspendTime.getTime();
                    durationDetail.setSuspendDuration(newSuspendDuration);
                    Long realDuration = newSuspendDuration - durationDetail.getCalendarDuration();
                    durationDetail.setRealDuration(realDuration);
                }
                durationDetailEntityManager.update(durationDetail);
            }
        }
    }

    @Override
    protected SuspensionState getNewState() {
        return ManagementConstants.ACTIVE;
    }
}

