/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;

public class BatchUpdateIdentityLinkDataCmd
implements Command<Void>,
Serializable {
    private static Log log = LogFactory.getLog(BatchUpdateIdentityLinkDataCmd.class);
    private static final long serialVersionUID = 1L;
    private List<IdentityLinkEntity> identityLinkEntities;
    private int limitSize = 300;
    Map<String, String> extendBusinessField;
    Map<Long, List<Object>> extendBusinessValue;
    private static final String STR_APOINT = "A.";

    public BatchUpdateIdentityLinkDataCmd(List<IdentityLinkEntity> identityLinkEntitie, int limitSize, Map<String, String> extendBusinessField, Map<Long, List<Object>> extendBusinessValue) {
        this.identityLinkEntities = identityLinkEntitie;
        this.limitSize = limitSize;
        this.extendBusinessField = extendBusinessField;
        this.extendBusinessValue = extendBusinessValue;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        HashMap<String, List<Object[]>> langParamList = new HashMap<String, List<Object[]>>(this.identityLinkEntities.size());
        ArrayList<Object[]> identityLinkparamsList = new ArrayList<Object[]>(this.identityLinkEntities.size());
        ArrayList<Object[]> businessTableparamsList = new ArrayList<Object[]>(this.identityLinkEntities.size());
        this.buildSqlParams(this.identityLinkEntities, langParamList, identityLinkparamsList, businessTableparamsList);
        try (TXHandle handle = TX.requiresNew();){
            String identityLinkSql = "update t_wf_participant set FEXECUTIONID=?,FTASKDEFID=?,FMOBILEFORMKEY=?,FCATEGORY=?,fentitynumber=?,FBUSINESSKEY=?,fprocessingmobilepage=?,FPROCESSINGPAGE=?,FSENDERID=?,fbillno=?,fstarterid=?,fendtype=?, fgroupnumber=?,fbilltype=?,fbiztraceno=?,fprocesstype=?,fextenddate=?,fextendnumber=?,fextendformat=?,fextendstr1=?,fextendstr2=?,ftaskstate=?,fbiztype=?,fsource=?,ftaskdisplay=?,FNAME=?,FENTITYNAME=?,FSENDERNAME=?,FSTARTNAME=?,fsendernameformat=?,fstartnameformat=?,fparticipantname=?,fextendmulstr1=?,fextendmulstr2=?,fcurrentsubject = ? where fid=?";
            WfDBUtils.executeBatch(identityLinkSql, identityLinkparamsList, this.limitSize);
            String identitylinkLangSql = "update t_wf_participant_l set FNAME=?,FENTITYNAME=?,FSENDERNAME=?,FSTARTNAME=?,fsendernameformat=?,fstartnameformat=?,fparticipantname=?,fextendmulstr1=?,fextendmulstr2=?,fcurrentsubject = ? where fid= ? and flocaleid = ?";
            for (Map.Entry entrySet : langParamList.entrySet()) {
                WfDBUtils.executeBatch(identitylinkLangSql, (List)entrySet.getValue(), this.limitSize);
            }
            StringBuilder queryFiels = new StringBuilder(" ");
            StringBuilder queryValue = new StringBuilder(" ");
            if (this.extendBusinessField.size() > 0) {
                for (Map.Entry<String, String> entry : this.extendBusinessField.entrySet()) {
                    queryFiels.append(",").append(entry.getValue().replace(STR_APOINT, ""));
                    queryValue.append(",").append("?");
                }
            }
            List<Object> ids = this.identityLinkEntities.stream().map(Entity::getId).collect(Collectors.toList());
            String taskClearSplitTableSql = "delete from t_wf_participant_a  where fid in (?)";
            WfDBUtils.executeBatchDeleteByIn(taskClearSplitTableSql, ids, null, false);
            StringBuilder businessSql = new StringBuilder();
            businessSql.append("insert into t_wf_participant_A (fid,fextenddate2 ,fextendnumber2 ").append((CharSequence)queryFiels).append(") values (?,?,?").append((CharSequence)queryValue).append(")");
            WfDBUtils.executeBatch(businessSql.toString(), businessTableparamsList, this.limitSize);
        }
        return null;
    }

    private void buildSqlParams(List<IdentityLinkEntity> identityLinkEntities, Map<String, List<Object[]>> langParamList, List<Object[]> identityLinkParamsList, List<Object[]> businessTableparamsList) {
        identityLinkEntities.forEach(identityLinkEntity -> {
            ArrayList<Object> tempParamArr = new ArrayList<Object>(18);
            HashMap<String, List<Object>> tempLangParamArr = new HashMap<String, List<Object>>();
            tempParamArr.add(identityLinkEntity.getExecutionId());
            tempParamArr.add(identityLinkEntity.getTaskDefinitionKey());
            tempParamArr.add(identityLinkEntity.getMobileFormKey());
            tempParamArr.add(identityLinkEntity.getCategory());
            tempParamArr.add(identityLinkEntity.getEntityNumber());
            tempParamArr.add(identityLinkEntity.getBusinessKey());
            tempParamArr.add(identityLinkEntity.getProcessingMobilePage());
            tempParamArr.add(identityLinkEntity.getProcessingPage());
            tempParamArr.add(identityLinkEntity.getSenderId());
            tempParamArr.add(identityLinkEntity.getBillNo());
            tempParamArr.add(identityLinkEntity.getStarterId() == null ? Long.valueOf(0L) : identityLinkEntity.getStarterId());
            tempParamArr.add(identityLinkEntity.getEndType());
            tempParamArr.add(identityLinkEntity.getGroupNumber());
            tempParamArr.add(identityLinkEntity.getBillType());
            tempParamArr.add(identityLinkEntity.getBizTraceNo());
            tempParamArr.add(identityLinkEntity.getProcessType());
            tempParamArr.add(identityLinkEntity.getBusinessDate());
            tempParamArr.add(identityLinkEntity.getBusinessNumber());
            tempParamArr.add(identityLinkEntity.getBusinessFormat());
            tempParamArr.add(identityLinkEntity.getBusinessStr1());
            tempParamArr.add(identityLinkEntity.getBusinessStr2());
            tempParamArr.add(identityLinkEntity.getTaskState());
            tempParamArr.add(identityLinkEntity.getBizType());
            tempParamArr.add(identityLinkEntity.getSource());
            tempParamArr.add(identityLinkEntity.isTaskDisplay());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, identityLinkEntity.getName());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, identityLinkEntity.getEntityName());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, identityLinkEntity.getSenderName());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, identityLinkEntity.getStartName());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, identityLinkEntity.getSenderNameFormat());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, identityLinkEntity.getStartNameFormat());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, identityLinkEntity.getParticipantName());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, identityLinkEntity.getBusinessMulStr1());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, identityLinkEntity.getBusinessMulStr2());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, identityLinkEntity.getCurrentSubject());
            tempParamArr.add(identityLinkEntity.getId());
            identityLinkParamsList.add(tempParamArr.toArray());
            for (Map.Entry entry : tempLangParamArr.entrySet()) {
                List list = (List)entry.getValue();
                list.add(identityLinkEntity.getId());
                list.add(entry.getKey());
                if (list.size() != 12) continue;
                List<Object> langParam = langParamList.get(entry.getKey()) == null ? new ArrayList<Object[]>() : (List)langParamList.get(entry.getKey());
                langParam.add(list.toArray());
                langParamList.put((String)entry.getKey(), (List<Object[]>)langParam);
            }
            ArrayList<Comparable<Long>> tempBusinessParamArr = new ArrayList<Comparable<Long>>(18);
            tempBusinessParamArr.add(identityLinkEntity.getId());
            tempBusinessParamArr.add(identityLinkEntity.getBusinessDate2());
            tempBusinessParamArr.add(Double.valueOf(identityLinkEntity.getBusinessNumber2()));
            ArrayList extendValues = new ArrayList(this.extendBusinessField.size());
            if (this.extendBusinessValue.get(identityLinkEntity.getId()) != null && this.extendBusinessValue.get(identityLinkEntity.getId()).size() > 0) {
                extendValues.addAll(this.extendBusinessValue.get(identityLinkEntity.getId()));
            }
            while (extendValues.size() < this.extendBusinessField.size()) {
                extendValues.add(null);
            }
            tempBusinessParamArr.addAll(extendValues);
            businessTableparamsList.add(tempBusinessParamArr.toArray());
        });
    }

    private void addLocaleStringField(List<Object> tempParamArr, Map<String, List<Object>> tempLangParamArr, ILocaleString ls) {
        if (WfUtils.isNotEmpty(ls)) {
            tempParamArr.add(ls.getLocaleValue() != null ? ls.getLocaleValue() : " ");
            for (Map.Entry entrySet : ls.entrySet()) {
                String key = (String)entrySet.getKey();
                List<Object> paramList = tempLangParamArr.get(key) != null ? tempLangParamArr.get(key) : new ArrayList();
                paramList.add(entrySet.getValue());
                tempLangParamArr.put(key, paramList);
            }
        } else {
            tempParamArr.add(" ");
            for (Map.Entry<String, List<Object>> entry : tempLangParamArr.entrySet()) {
                List<Object> paramList = entry.getValue();
                if (paramList == null) {
                    paramList = new ArrayList<Object>();
                }
                paramList.add(" ");
                tempLangParamArr.put(entry.getKey(), paramList);
            }
        }
    }
}

