/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;

public class BatchUpdateTaskHandleLogDataCmd
implements Command<Void>,
Serializable {
    private static Log log = LogFactory.getLog(BatchUpdateTaskHandleLogDataCmd.class);
    private static final long serialVersionUID = 1L;
    private List<TaskHandleLogEntity> taskHandleLogEntities;
    private int limitSize = 300;

    public BatchUpdateTaskHandleLogDataCmd(List<TaskHandleLogEntity> taskHandleLogEntities, int limitSize) {
        this.taskHandleLogEntities = taskHandleLogEntities;
        this.limitSize = limitSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void execute(CommandContext commandContext) {
        HashMap<String, List<Object[]>> langParamList = new HashMap<String, List<Object[]>>(this.taskHandleLogEntities.size());
        ArrayList<Object[]> taskHandleLogParamsList = new ArrayList<Object[]>(this.taskHandleLogEntities.size());
        this.buildSqlParams(this.taskHandleLogEntities, langParamList, taskHandleLogParamsList);
        try (TXHandle handle = TX.requiresNew();){
            String taskHandleLog = "update t_wf_taskhandlelog set fisdisplay=?,fendtype=?,fprocesstype=?,fexecutiontype=?,fendtime=?,fpriority = ?,fcompositetaskid = ?,ftaskstate=?,fsource=?,fbiztype=?,fbiztraceno=?,fgroupnumber=?,fentityname=?,fstartname=?,fstartnameformat=?,fpresentassignee=?,fsendername=?,fsendernameformat=? where fid=?";
            WfDBUtils.executeBatch(taskHandleLog, taskHandleLogParamsList, this.limitSize);
            String taskHandleLogLangSql = "update t_wf_taskhandlelog_l set fentityname=?,fstartname=?,fstartnameformat=?,fpresentassignee=?,fsendername=?,fsendernameformat=? where fid= ? and flocaleid = ?";
            for (Map.Entry entrySet : langParamList.entrySet()) {
                WfDBUtils.executeBatch(taskHandleLogLangSql, (List)entrySet.getValue(), this.limitSize);
            }
        }
        return null;
    }

    private void buildSqlParams(List<TaskHandleLogEntity> taskHandleLogEntities, Map<String, List<Object[]>> langParamList, List<Object[]> taskHandleLogParamsList) {
        taskHandleLogEntities.forEach(taskHandleLogEntity -> {
            ArrayList<Object> tempParamArr = new ArrayList<Object>(18);
            HashMap<String, List<Object>> tempLangParamArr = new HashMap<String, List<Object>>();
            tempParamArr.add(taskHandleLogEntity.isDisplay());
            tempParamArr.add(taskHandleLogEntity.getEndType());
            tempParamArr.add(taskHandleLogEntity.getProcessType());
            tempParamArr.add(taskHandleLogEntity.getExecutionType());
            tempParamArr.add(taskHandleLogEntity.getEndTime());
            tempParamArr.add(taskHandleLogEntity.getPriority());
            tempParamArr.add(taskHandleLogEntity.getCompositeTaskId());
            tempParamArr.add(taskHandleLogEntity.getTaskState());
            tempParamArr.add(taskHandleLogEntity.getSource());
            tempParamArr.add(taskHandleLogEntity.getBizType());
            tempParamArr.add(taskHandleLogEntity.getBizTraceNo());
            tempParamArr.add(taskHandleLogEntity.getGroupNumber());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, taskHandleLogEntity.getEntityName());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, taskHandleLogEntity.getStartName());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, taskHandleLogEntity.getStartNameFormat());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, taskHandleLogEntity.getPresentAssignee());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, taskHandleLogEntity.getSenderName());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, taskHandleLogEntity.getSenderNameFormat());
            tempParamArr.add(taskHandleLogEntity.getId());
            taskHandleLogParamsList.add(tempParamArr.toArray());
            for (Map.Entry entry : tempLangParamArr.entrySet()) {
                List list = (List)entry.getValue();
                list.add(taskHandleLogEntity.getId());
                list.add(entry.getKey());
                if (list.size() != 8) continue;
                List<Object> langParam = langParamList.get(entry.getKey()) == null ? new ArrayList<Object[]>() : (List)langParamList.get(entry.getKey());
                langParam.add(list.toArray());
                langParamList.put((String)entry.getKey(), (List<Object[]>)langParam);
            }
        });
    }

    private void addLocaleStringField(List<Object> tempParamArr, Map<String, List<Object>> tempLangParamArr, ILocaleString ls) {
        if (WfUtils.isNotEmpty(ls)) {
            tempParamArr.add(ls.getLocaleValue() != null ? ls.getLocaleValue() : " ");
            for (Map.Entry entrySet : ls.entrySet()) {
                String key = (String)entrySet.getKey();
                List<Object> paramList = tempLangParamArr.get(key) != null ? tempLangParamArr.get(key) : new ArrayList();
                paramList.add(entrySet.getValue());
                tempLangParamArr.put(key, paramList);
            }
        } else {
            tempParamArr.add(" ");
            for (Map.Entry<String, List<Object>> entry : tempLangParamArr.entrySet()) {
                List<Object> paramList = entry.getValue();
                if (paramList == null) {
                    paramList = new ArrayList<Object>();
                }
                paramList.add(" ");
                tempLangParamArr.put(entry.getKey(), paramList);
            }
        }
    }
}

