/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;

public class CalculateAuditPointCheckResultCmd
implements Command<Map<String, Object>>,
Serializable {
    private static final long serialVersionUID = -4573221442893640451L;
    private String conditionExpression;
    private VariableScope variableScope;
    private String key;

    public CalculateAuditPointCheckResultCmd(String conditionExpression, VariableScope variableScope, String key) {
        this.conditionExpression = conditionExpression;
        this.variableScope = variableScope;
        this.key = key;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        HashMap<String, Object> checkResult = new HashMap<String, Object>();
        Boolean isPassed = Boolean.FALSE;
        try {
            if (!WfUtils.isEmpty(this.conditionExpression)) {
                isPassed = ConditionUtil.hasTrueCondition(this.conditionExpression, this.variableScope, this.key);
            }
        }
        catch (KDBizException e) {
            checkResult.put("failedReason", e.getMessage());
            throw new KDException(BosErrorCode.systemError, new Object[]{e.getMessage()});
        }
        checkResult.put("isPassed", isPassed);
        return checkResult;
    }
}

