/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;

public class CancelJobsCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Long> jobIds;

    public CancelJobsCmd(List<Long> jobIds) {
        this.jobIds = jobIds;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        JobEntity jobToDelete = null;
        for (Long jobId : this.jobIds) {
            jobToDelete = (JobEntity)commandContext.getJobEntityManager().findById(jobId);
            if (jobToDelete != null) {
                if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                    commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, jobToDelete));
                }
                commandContext.getJobEntityManager().delete(jobToDelete);
                continue;
            }
            TimerJobEntity timerJobToDelete = (TimerJobEntity)commandContext.getTimerJobEntityManager().findById(jobId);
            if (timerJobToDelete == null) continue;
            if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, timerJobToDelete));
            }
            commandContext.getTimerJobEntityManager().delete(timerJobToDelete);
        }
        return null;
    }
}

