/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.LanguageUtil;

public class CleanMultiLangDirtyDataCmd
implements Command<Boolean> {
    private static Log logger = LogFactory.getLog(CleanMultiLangDirtyDataCmd.class);
    private static final String KEY_RETAINLANG = "retainLang";
    private static final String KEY_MULTITABLES_TOPNUM = "multiTablesTopNum";
    private static final String KEY_MULTITABLES_INFO = "multiTablesInfo";
    private static final String CLASSNAME = "CleanMultiLangDirtyDataTask";
    private static final Long TOPNUMBER = 20000L;
    private static final Integer BATCHNUM = 200;
    private static final String WF_CONFCENTER = "wf_confcenter";
    private static final String MAXFID = "maxFid";
    private static final String FID = "fid";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String TABLE = "table";
    private static final String SELECT_FIELD = "id,key,value";
    private static final String FORMAT = "%s.%s";
    private static final String FIELD_FID = "FID";
    protected String tables;

    public CleanMultiLangDirtyDataCmd(String tables) {
        this.tables = tables;
    }

    @Override
    public Boolean execute(CommandContext commandContext) {
        try {
            for (int i = 0; i < 3; ++i) {
                this.exeDefaultStrategy(this.tables);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void exeDefaultStrategy(String tables) {
        String[] tablesName;
        Map map;
        Long topNum = TOPNUMBER;
        Integer batchNum = BATCHNUM;
        String tempData = (String)CleanMultiLangDirtyDataCmd.getConfCenterInfo(KEY_MULTITABLES_TOPNUM);
        if (WfUtils.isNotEmpty(tempData) && null != (map = (Map)SerializationUtils.fromJsonString((String)tempData, Map.class)) && map.size() > 0) {
            topNum = Long.valueOf(String.valueOf(map.get("topNum")));
            batchNum = Integer.valueOf(String.valueOf(map.get("batchNum")));
        }
        for (String tableName : tablesName = CleanMultiLangDirtyDataCmd.getTables(tables)) {
            if (tableName.endsWith("_l") || tableName.endsWith("_L")) {
                CleanMultiLangDirtyDataCmd.executeClean(tableName, batchNum, topNum, tables);
                continue;
            }
            String muilTableName = tableName.concat("_l");
            CleanMultiLangDirtyDataCmd.executeClean(muilTableName, batchNum, topNum, tables);
        }
    }

    public static void executeClean(String muilTableName, Integer batchNum, Long topNum, String tables) {
        List<Object[]> ids;
        Long maxFid = 0L;
        Long lastFid = 0L;
        Long currentMaxId = 0L;
        StringBuilder delSql = new StringBuilder("DELETE FROM ").append(muilTableName).append(" WHERE ");
        Map<String, Long> tempMap = CleanMultiLangDirtyDataCmd.getLastFid(muilTableName);
        if (tempMap.size() > 0) {
            lastFid = tempMap.get(FID);
            maxFid = tempMap.get(MAXFID);
        }
        if (null != (ids = CleanMultiLangDirtyDataCmd.getIdsByMuilTable(muilTableName, topNum, lastFid, tables)) && ids.size() > 0) {
            currentMaxId = lastFid = (Long)ids.get(ids.size() - 1)[0];
            delSql.append("  FID in (?) ");
            delSql.append(" AND ").append(" FLOCALEID ").append(" NOT IN ").append(CleanMultiLangDirtyDataCmd.contactLangSql());
            try {
                WfDBUtils.executeBatchDeleteByIn(delSql.toString(), CleanMultiLangDirtyDataCmd.getListObject(ids), batchNum, true);
                logger.debug("delete successed");
            }
            catch (Exception e) {
                logger.error(String.format("delete records occured exception -{%s}", WfUtils.getExceptionStacktrace(e)));
            }
        }
    }

    private static List<Object[]> getIdsByMuilTable(String muilTableName, Long topNum, Long lastFid, String tables) {
        StringBuilder querySql = new StringBuilder("SELECT TOP ").append(topNum).append(" FID FROM ");
        querySql.append(muilTableName);
        if (lastFid.intValue() != 0) {
            querySql.append(" WHERE FID > ").append(lastFid);
        }
        querySql.append(" ORDER BY FID ");
        List ids = (List)DB.query((DBRoute)DBRoute.workflow, (String)querySql.toString(), (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws SQLException {
                ArrayList<Object[]> ret = new ArrayList<Object[]>(16);
                while (rs.next()) {
                    Object[] t = new Object[]{rs.getLong(CleanMultiLangDirtyDataCmd.FIELD_FID)};
                    ret.add(t);
                }
                return ret;
            }
        });
        if (ids.size() > 0) {
            lastFid = (Long)((Object[])ids.get(ids.size() - 1))[0];
            CleanMultiLangDirtyDataCmd.insertOrUpdateConfCenterInfo(muilTableName, lastFid, false, tables);
        }
        return ids;
    }

    private static void insertOrUpdateConfCenterInfo(String muilTableName, Long fid, Boolean removeFlag, String tables) {
        String value;
        String confKey = String.format(FORMAT, CLASSNAME, KEY_MULTITABLES_INFO);
        DynamicObject valueObj = BusinessDataServiceHelper.loadSingle((String)WF_CONFCENTER, (String)SELECT_FIELD, (QFilter[])new QFilter[]{new QFilter(KEY, "=", (Object)confKey)});
        if (valueObj == null) {
            valueObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)WF_CONFCENTER));
            valueObj.set(KEY, (Object)confKey);
        }
        if (WfUtils.isEmpty(value = (String)valueObj.get(VALUE))) {
            String[] tableList = CleanMultiLangDirtyDataCmd.getTables(tables);
            ArrayList valueList = new ArrayList(tableList.length);
            for (String table : tableList) {
                HashMap<String, Object> valueMap = new HashMap<String, Object>();
                valueMap.put(TABLE, table);
                if (muilTableName.contains(table)) {
                    valueMap.put(FID, fid);
                } else {
                    valueMap.put(FID, 0L);
                }
                valueMap.put(MAXFID, CleanMultiLangDirtyDataCmd.getMaxFId(table));
                valueList.add(valueMap);
            }
            valueObj.set(VALUE, (Object)JSONObject.toJSONString(valueList));
            valueObj.set("type", (Object)"global");
            valueObj.set("description", (Object)"muilTable-config");
            DynamicObject[] dynObjs = new DynamicObject[]{valueObj};
            SaveServiceHelper.save((DynamicObject[])dynObjs);
        } else {
            List tempList = SerializationUtils.fromJsonStringToList((String)value, Map.class);
            if (WfUtils.isNotEmptyForCollection(tempList)) {
                Iterator iterator = tempList.iterator();
                boolean find = false;
                while (iterator.hasNext()) {
                    Map tempMap = (Map)iterator.next();
                    if (!muilTableName.equalsIgnoreCase((String)tempMap.get(TABLE))) continue;
                    if (!removeFlag.booleanValue()) {
                        tempMap.put(FID, fid);
                        find = true;
                        break;
                    }
                    iterator.remove();
                }
                if (!find) {
                    HashMap<String, Object> valueMap = new HashMap<String, Object>();
                    valueMap.put(TABLE, muilTableName);
                    valueMap.put(FID, fid);
                    valueMap.put(MAXFID, CleanMultiLangDirtyDataCmd.getMaxFId(muilTableName));
                    tempList.add(valueMap);
                }
                if (tempList.isEmpty()) {
                    DeleteServiceHelper.delete((String)WF_CONFCENTER, (QFilter[])new QFilter[]{new QFilter(KEY, "=", (Object)confKey)});
                } else {
                    valueObj.set(VALUE, (Object)JSONObject.toJSONString((Object)tempList));
                    DynamicObject[] dynObjs = new DynamicObject[]{valueObj};
                    SaveServiceHelper.save((DynamicObject[])dynObjs);
                }
            } else {
                DeleteServiceHelper.delete((String)WF_CONFCENTER, (QFilter[])new QFilter[]{new QFilter(KEY, "=", (Object)confKey)});
            }
        }
    }

    public static Long getMaxFId(String tableName) {
        Long result = 0L;
        StringBuilder sql = new StringBuilder(" SELECT TOP 1 FID FROM ");
        sql.append(tableName).append(" ORDER BY FID DESC ");
        try (DataSet dataset = DB.queryDataSet((String)"wf.CleanMultiLangDirtyDataCmd.getMaxFId", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[0]);){
            Iterator iterator = dataset.iterator();
            if (iterator != null && iterator.hasNext()) {
                Row row = (Row)iterator.next();
                result = (Long)row.get(FIELD_FID);
            }
        }
        return result;
    }

    private static Map<String, Long> getLastFid(String muilTableName) {
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        String value = CleanMultiLangDirtyDataCmd.getWfConfCenterInfoValue();
        if (WfUtils.isNotEmpty(value)) {
            List tempList = SerializationUtils.fromJsonStringToList((String)value, Map.class);
            for (Object object : tempList) {
                Map tempMap = (Map)object;
                if (!muilTableName.equalsIgnoreCase((String)tempMap.get(TABLE))) continue;
                resultMap.put(FID, tempMap.get(FID) != null ? Long.parseLong(String.valueOf(tempMap.get(FID))) : 0L);
                resultMap.put(MAXFID, tempMap.get(MAXFID) != null ? Long.parseLong(String.valueOf(tempMap.get(MAXFID))) : 0L);
                return resultMap;
            }
        }
        return resultMap;
    }

    private static String getWfConfCenterInfoValue() {
        String confKey = String.format(FORMAT, CLASSNAME, KEY_MULTITABLES_INFO);
        DynamicObject valueObj = BusinessDataServiceHelper.loadSingle((String)WF_CONFCENTER, (String)SELECT_FIELD, (QFilter[])new QFilter[]{new QFilter(KEY, "=", (Object)confKey)});
        if (valueObj == null) {
            valueObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)WF_CONFCENTER));
            valueObj.set(KEY, (Object)confKey);
        }
        return (String)valueObj.get(VALUE);
    }

    private static String[] getTables(String tables) {
        if (tables.contains(",")) {
            return tables.split(",");
        }
        if (tables.contains("\uff0c")) {
            return tables.split("\uff0c");
        }
        return new String[]{tables};
    }

    private static List<Object> getListObject(List<Object[]> temp) {
        ArrayList<Object> dataList = new ArrayList<Object>(temp.size());
        for (Object[] objects : temp) {
            dataList.add(objects[0]);
        }
        return dataList;
    }

    private static List<String> getLanguages() {
        ArrayList<String> resultLangs = new ArrayList();
        String tempLang = (String)CleanMultiLangDirtyDataCmd.getConfCenterInfo(KEY_RETAINLANG);
        if (WfUtils.isEmpty(tempLang) || "0".equals(tempLang)) {
            resultLangs = LanguageUtil.getSupportLangs();
        } else {
            String[] temp;
            for (String lang : temp = tempLang.split(",")) {
                resultLangs.add(lang.trim());
            }
        }
        return resultLangs;
    }

    private static String contactLangSql() {
        StringBuilder sbBuilder = new StringBuilder("(");
        List<String> langs = CleanMultiLangDirtyDataCmd.getLanguages();
        if (langs.size() > 0) {
            for (int i = 0; i < langs.size(); ++i) {
                sbBuilder.append("'").append(langs.get(i).replace("\"", "").replace("\u201c", "").replace("\u201d", "").trim()).append("'").append(",");
            }
        }
        if (sbBuilder.length() > 1) {
            return sbBuilder.deleteCharAt(sbBuilder.length() - 1).append(")").toString();
        }
        return "('0')";
    }

    public static Object getConfCenterInfo(String key) {
        String fullKey = String.format(FORMAT, CLASSNAME, key);
        return WfConfigurationUtil.getConfigCenterVal(fullKey);
    }
}

