/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.FailedJobEntity;

public class DeleteFailedJobsCmd
implements Command<Void> {
    private List<Long> jobIds;
    private String appId;

    public DeleteFailedJobsCmd(List<Long> jobIds, String appId) {
        this.jobIds = jobIds;
        this.appId = appId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", this.jobIds)};
        List failedJobs = commandContext.getFailedJobEntityManager().findByQueryFilters(filters);
        StringBuilder sb = new StringBuilder();
        Long id = null;
        for (FailedJobEntity failedJob : failedJobs) {
            id = failedJob.getId();
            sb.append(this.getTaskIdDesc(failedJob));
            commandContext.getFailedJobEntityManager().delete(failedJob);
        }
        WfUtils.addOpLogByAppId(this.appId, "wf_failedjob", "btndelete", new MultiLangEnumBridge("\u5220\u9664\u5931\u8d25\u4efb\u52a1", "DeleteFailedJobsCmd_1", "bos-wf-engine"), null, String.format("Id:[%s]%s", id, sb.toString()));
        return null;
    }

    private String getTaskIdDesc(FailedJobEntity failedJob) {
        String ret = null;
        JSONObject configuration = JSON.parseObject((String)failedJob.getJobHandlerConfiguration());
        String modelStr = configuration.getString("model");
        if (WfUtils.isNotEmpty(modelStr)) {
            JSONObject model = JSON.parseObject((String)modelStr);
            ret = String.format("TaskId: %s. ", model.get((Object)"taskId"));
        } else {
            ret = String.format("JobId: %s. ", failedJob.getId());
        }
        return ret;
    }
}

