/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityManager;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class DeleteModelsCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long[] modelIds;

    public DeleteModelsCmd(Long[] modelIds) {
        this.modelIds = modelIds;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.modelIds == null) {
            throw new WFIllegalArgumentException("modelIds is null");
        }
        ModelEntityManager modelEntityManager = commandContext.getModelEntityManager();
        ModelEntity model = null;
        for (Long modelId : this.modelIds) {
            model = (ModelEntity)modelEntityManager.findById(modelId);
            modelEntityManager.delete(modelId);
            String appType = "wf";
            if ("BizFlow".equals(model.getType())) {
                appType = "bpm";
            }
            WfUtils.addOpLogByAppType(appType, "wf_model", "delete", ResManager.getLocaleString((String)"\u5220\u9664\u6d41\u7a0b", (String)"DeleteModelsCmd_1", (String)"bos-wf-engine").getLocaleValue_zh_CN(), new MultiLangEnumBridge("\u6d41\u7a0b\u540d\u79f0\uff1a%1$s\uff0c\u6d41\u7a0bID\uff1a%2$s\uff0c\u6d41\u7a0b\u7f16\u7801\uff1a%3$s\u3002", "DeleteModelsCmd_2", "bos-wf-engine"), model.getName(), modelId, model.getKey());
        }
        return null;
    }
}

