/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntityManager;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class DeleteProcessCategoriesByIdsCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Long> categoryIds;

    public DeleteProcessCategoriesByIdsCmd(List<Long> categoryIds) {
        this.categoryIds = categoryIds;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.categoryIds == null || this.categoryIds.isEmpty()) {
            throw new WFIllegalArgumentException("categoryIds is null");
        }
        ProcessCategoryEntityManager processCategoryEntityManager = commandContext.getProcessCategoryEntityManager();
        ProcessCategoryEntity processCategory = null;
        for (Long categoryId : this.categoryIds) {
            processCategory = (ProcessCategoryEntity)processCategoryEntityManager.findById(categoryId);
            processCategoryEntityManager.delete(categoryId);
            WfUtils.addOpLog("wf_processcagetory", "delete", new MultiLangEnumBridge("\u5220\u9664\u6d41\u7a0b\u5206\u7c7b", "DeleteProcessCategoriesByIdsCmd_1", "bos-wf-engine"), new MultiLangEnumBridge("\u6d41\u7a0b\u5206\u7c7b\u540d\u79f0\uff1a%1$s\uff0c\u6d41\u7a0b\u5206\u7c7bID\uff1a%2$s\uff0c\u6d41\u7a0b\u5206\u7c7b\u7f16\u7801\uff1a%3$s\u3002", "DeleteProcessCategoriesByIdsCmd_2", "bos-wf-engine"), processCategory.getName(), categoryId, processCategory.getNumber());
        }
        return null;
    }
}

