/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.engine.impl.cmd.DeleteProcessCategoriesByIdsCmd;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntityManager;

public class DeleteProcessCategoryCmd
implements Command<Void> {
    private ProcessCategoryEntity entity;

    public DeleteProcessCategoryCmd(ProcessCategoryEntity entity) {
        this.entity = entity;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ProcessCategoryEntityManager manager = commandContext.getProcessCategoryEntityManager();
        manager.delete(this.entity);
        if (!this.entity.isLeaf().booleanValue()) {
            EntityQueryBuilder queryBuilder = manager.createQueryBuilder();
            queryBuilder.addFilter("parentid", this.entity.getId()).setSelectFields("id");
            List children = manager.findByQueryBuilder(queryBuilder);
            if (children.isEmpty()) {
                return null;
            }
            ArrayList<Long> categoryIds = new ArrayList<Long>(children.size());
            for (ProcessCategoryEntity child : children) {
                categoryIds.add(child.getId());
            }
            new DeleteProcessCategoriesByIdsCmd(categoryIds).execute(commandContext);
        }
        return null;
    }
}

