/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;

public class FindBillEnterProcessTimesCmd
implements Command<Long> {
    private final String businessKey;

    public FindBillEnterProcessTimesCmd(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public Long execute(CommandContext commandContext) {
        long size = 0L;
        QFilter qFilter = new QFilter("processtype", "in", (Object)Lists.newArrayList((Object[])new String[]{ModelType.AuditFlow.name(), ModelType.BizFlow.name()}));
        QFilter qFilter2 = new QFilter("businesskey", "=", (Object)this.businessKey);
        QFilter qFilter3 = new QFilter("superprocessinstanceid", "=", (Object)0);
        List entities = commandContext.getHistoricProcessInstanceEntityManager().findByQueryFilters(new QFilter[]{qFilter, qFilter2, qFilter3});
        if (CollectionUtil.isEmpty(entities)) {
            return size;
        }
        ArrayList<Long> ids = new ArrayList<Long>(entities.size());
        for (HistoricProcessInstanceEntity entity : entities) {
            ids.add(entity.getId());
        }
        List commentEntities = commandContext.getCommentEntityManager().findByQueryFilters(new QFilter[]{new QFilter("processinstanceid", "in", ids)});
        if (CollectionUtil.isEmpty(commentEntities)) {
            return size;
        }
        HashSet<Long> procinstIds = new HashSet<Long>(commentEntities.size());
        for (CommentEntity commentEntity : commentEntities) {
            procinstIds.add(commentEntity.getProcessInstanceId());
        }
        return procinstIds.size();
    }
}

