/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;

public class FindEntitiesByFiltersCmd<T extends Entity>
implements Command<List<T>> {
    private String entityNumber;
    private QFilter[] filters;
    private String fields;
    private String orderBy;

    public FindEntitiesByFiltersCmd(String entityNumber, QFilter[] filters) {
        this.entityNumber = entityNumber;
        this.filters = (QFilter[])filters.clone();
    }

    public FindEntitiesByFiltersCmd(String entityNumber, QFilter[] filters, String fields, String orderBy) {
        this.entityNumber = entityNumber;
        this.filters = filters;
        this.fields = fields;
        this.orderBy = orderBy;
    }

    @Override
    public List<T> execute(CommandContext commandContext) {
        if (this.fields != null && this.orderBy != null) {
            return commandContext.getEntityManagerByEntityNumber(this.entityNumber).findByQueryFilters(this.filters, this.fields, this.orderBy);
        }
        return commandContext.getEntityManagerByEntityNumber(this.entityNumber).findByQueryFilters(this.filters);
    }
}

