/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class GenerateModelAutoKeyNumberCMD
implements Command<Integer>,
Serializable {
    private static final long serialVersionUID = -7450848010247621345L;
    private Map<String, String> modelInfoMap;

    public GenerateModelAutoKeyNumberCMD(Map<String, String> modelInfoMap) {
        this.modelInfoMap = modelInfoMap;
    }

    @Override
    public Integer execute(CommandContext commandContext) {
        if (this.modelInfoMap == null) {
            throw new WFIllegalArgumentException("modelInfoMap is null");
        }
        String preNumber = this.createAutoKeyPre(this.modelInfoMap.get("orgUnitNumber"), this.modelInfoMap.get("billNumber"));
        int autoKeyNumber = 0;
        String fields = "key";
        QFilter qEntraBillId = new QFilter("entrabillid", "=", (Object)this.modelInfoMap.get("entraBillId"));
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(this.createAlgoKey(), "wf_model", fields, new QFilter[]{qEntraBillId});){
            for (Row row : ds) {
                String key = (String)row.get("key");
                int index = key.indexOf(preNumber);
                if (index != 0) continue;
                String number = key.substring(index + preNumber.length());
                try {
                    if (Integer.parseInt(number) <= autoKeyNumber) continue;
                    autoKeyNumber = Integer.parseInt(number);
                }
                catch (NumberFormatException e) {}
            }
        }
        return autoKeyNumber + 1;
    }

    protected String createAlgoKey() {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        return new StringBuffer().append("bos.wf.").append(this.getClass().getName()).append(".").append(methodName).toString();
    }

    private String createAutoKeyPre(String orgUnitNumber, String billNumber) {
        return "Proc_" + billNumber + "_audit_";
    }
}

