/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;

public class GetApproversMapByBusinessKeysCmd
implements Command<Map<String, List<Long>>> {
    private String[] businessKeys;

    public GetApproversMapByBusinessKeysCmd(String[] businesskeysParam) {
        this.businessKeys = businesskeysParam;
    }

    @Override
    public Map<String, List<Long>> execute(CommandContext commandContext) {
        HashMap<String, List<Long>> approversMap = new HashMap<String, List<Long>>();
        if (this.businessKeys == null || this.businessKeys.length < 1) {
            return approversMap;
        }
        QFilter[] filters = new QFilter[]{new QFilter("businessKey", "in", (Object)this.businessKeys)};
        List tasks = commandContext.getTaskEntityManager().findByQueryFilters(filters, String.format("%s,%s", "id", "businessKey"), null);
        if (tasks.isEmpty()) {
            return approversMap;
        }
        HashMap<Long, String> taskBusKeyMap = new HashMap<Long, String>(tasks.size());
        for (TaskEntity task : tasks) {
            taskBusKeyMap.put(task.getId(), task.getBusinessKey());
        }
        QFilter[] participantFilters = new QFilter[]{new QFilter("taskid", "in", taskBusKeyMap.keySet())};
        String fields = String.format("%s,%s", "userid", "taskid");
        List participants = commandContext.getIdentityLinkEntityManager().findByQueryFilters(participantFilters, fields, null);
        if (participants.isEmpty()) {
            return approversMap;
        }
        approversMap = new HashMap(participants.size());
        for (IdentityLinkEntity participant : participants) {
            Long userId = participant.getUserId();
            Long taskId = participant.getTaskId();
            String businessKey = (String)taskBusKeyMap.get(taskId);
            ArrayList<Long> userIds = (ArrayList<Long>)approversMap.get(businessKey);
            if (userIds == null) {
                userIds = new ArrayList<Long>();
                approversMap.put(businessKey, userIds);
            }
            userIds.add(userId);
        }
        return approversMap;
    }
}

