/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.HashMap;
import java.util.Map;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;

public class GetBizApplierInfoByProInsIdCmd
implements Command<Map<String, Object>> {
    private Long processInstanceId;
    private static final String BIZAPPLIER = "bizApplier";

    public GetBizApplierInfoByProInsIdCmd(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        if (this.processInstanceId == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, String> bizApplierInfo = commandContext.getHistoricVariableInstanceEntityManager().findBizApplierInfoByProcessInstanceId(this.processInstanceId);
        if (bizApplierInfo != null && !bizApplierInfo.isEmpty()) {
            String bizApplier = bizApplierInfo.get(BIZAPPLIER);
            if (WfUtils.isNotEmpty(bizApplier)) {
                result.put(BIZAPPLIER, bizApplier);
                result.put("bizApplierName", WfUtils.findUserName(Long.valueOf(bizApplier)));
            }
        } else {
            HistoricProcessInstanceEntity instance = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(this.processInstanceId);
            if (instance != null && instance.getStartName() != null) {
                result.put(BIZAPPLIER, String.valueOf(instance.getStartUserId()));
                result.put("bizApplierName", instance.getStartName());
            }
        }
        return result;
    }
}

