/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.HashMap;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnModelCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class GetBpmnModelForSchemeCmd
implements Command<BpmnModel> {
    private Long processDefinitionId;
    private VariableScope variableScope;

    public GetBpmnModelForSchemeCmd(Long processDefinitionId, VariableScope variableScope) {
        this.processDefinitionId = processDefinitionId;
        this.variableScope = variableScope;
    }

    @Override
    public BpmnModel execute(CommandContext commandContext) {
        ProcessDefinitionEntity def;
        BpmnModel model = null;
        if (WfUtils.isNotEmpty(this.processDefinitionId) && null != this.variableScope && (def = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(this.processDefinitionId, "id,key,version")) != null) {
            HashMap<String, Object> target = new HashMap<String, Object>();
            target.put("id", def.getId());
            target.put("number", def.getKey());
            target.put("version", def.getVersion());
            Long schemeId = BpmnModelUtil.filterSchemeByCondition(commandContext, target, this.variableScope);
            if (WfUtils.isNotEmpty(schemeId)) {
                model = new GetConfigSchemeBpmnModelCmd(schemeId).execute(commandContext);
            }
        }
        return model;
    }
}

