/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.utils.DbTypeConverter;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.task.BusinessKeyQueryParams;

public class GetBusinessKeyByEntityNumberCmd
implements Command<List<Object>>,
Serializable {
    private static final Log log = LogFactory.getLog(GetBusinessKeyByEntityNumberCmd.class);
    private BusinessKeyQueryParams businessKeyQueryParams;

    public GetBusinessKeyByEntityNumberCmd(BusinessKeyQueryParams businessKeyQueryParams) {
        this.businessKeyQueryParams = businessKeyQueryParams;
    }

    @Override
    public List<Object> execute(CommandContext commandContext) {
        if (WfUtils.isEmptyForArrays(this.businessKeyQueryParams.getUserIds()) || WfUtils.isEmpty(this.businessKeyQueryParams.getEntitynumber())) {
            log.warn("\u53c2\u6570\u4e3a\u7a7a\uff0cusersIds=" + Arrays.toString((Object[])this.businessKeyQueryParams.getUserIds()) + "\uff1bentitynumber=" + this.businessKeyQueryParams.getEntitynumber());
            return Collections.emptyList();
        }
        boolean isFixed = WfConfigurationUtil.isUpdateTaskToParticipantComplete();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(String.format("select distinct top 100000 %s.fbusinesskey from ", isFixed ? "twp" : "twt"), new Object[0]);
        sqlBuilder.append(isFixed ? "t_wf_participant twp " : "t_wf_task twt inner join t_wf_participant twp on twt.fid = twp.ftaskid ", new Object[0]);
        sqlBuilder.appendIn("where twp.fuserid ", (Object[])this.businessKeyQueryParams.getUserIds());
        sqlBuilder.append("and twp.ftype = 'participant' ", new Object[0]);
        sqlBuilder.append(isFixed ? " " : "and twp.fisdisplay = '1' ", new Object[0]);
        sqlBuilder.append(String.format("and %1$s.fentitynumber = ? and %1$s.fisdisplay = '1' ", isFixed ? "twp" : "twt"), new Object[]{this.businessKeyQueryParams.getEntitynumber()});
        List results = Collections.emptyList();
        try {
            int dbType = this.getEntityDbType(this.businessKeyQueryParams.getEntitynumber());
            results = (List)DB.query((DBRoute)DBRoute.workflow, (SqlBuilder)sqlBuilder, rs -> {
                ArrayList idSet = Lists.newArrayListWithExpectedSize((int)16);
                while (rs.next()) {
                    idSet.add(DbTypeConverter.safeConvert((int)dbType, (Object)rs.getString("fbusinesskey")));
                }
                return idSet;
            });
        }
        catch (Exception e) {
            log.error(String.format("\u6839\u636e\u5f53\u524d\u5ba1\u6279\u4eba\u6761\u4ef6\u67e5\u8be2\u6d41\u7a0b\u5e93\u5f02\u5e38error\uff1a%1$s\uff1bsql\uff1a%2$s", e.getMessage(), sqlBuilder), (Throwable)e);
        }
        return results;
    }

    private int getEntityDbType(String entityId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        return entityType.getPrimaryKey().getDbType();
    }
}

