/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class GetBusinessKeyByProcessInstanceIdCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1806631867229118276L;
    private Long processInstanceId;

    public GetBusinessKeyByProcessInstanceIdCmd(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        if (this.processInstanceId == null) {
            throw new WFIllegalArgumentException("processInstanceId is null");
        }
        ExecutionEntity processInstance = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.processInstanceId);
        if (processInstance != null) {
            return processInstance.getBusinessKey();
        }
        HistoricProcessInstanceEntity hiProcInst = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(this.processInstanceId);
        if (hiProcInst != null) {
            return hiProcInst.getBusinessKey();
        }
        return null;
    }
}

