/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstance;
import kd.bos.workflow.engine.runtime.Execution;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.exception.WFObjectNotFoundException;

public class GetExecutionVariableInstancesCmd
implements Command<Map<String, VariableInstance>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Long executionId;
    private Collection<String> variableNames;
    protected boolean isLocal;

    public GetExecutionVariableInstancesCmd(Long executionId, Collection<String> variableNames, boolean isLocal) {
        this.executionId = executionId;
        this.variableNames = variableNames;
        this.isLocal = isLocal;
    }

    @Override
    public Map<String, VariableInstance> execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new WFIllegalArgumentException("executionId is null");
        }
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
        if (execution == null) {
            throw new WFObjectNotFoundException("execution " + this.executionId + " doesn't exist", Execution.class);
        }
        Map<String, VariableInstance> variables = null;
        variables = this.variableNames == null || this.variableNames.isEmpty() ? (this.isLocal ? execution.getVariableInstancesLocal() : execution.getVariableInstances()) : (this.isLocal ? execution.getVariableInstancesLocal(this.variableNames, false) : execution.getVariableInstances(this.variableNames, false));
        return variables;
    }
}

