/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.management.GetExportSchemeFileCmd;
import kd.bos.workflow.engine.impl.cmd.model.GetDeployModelFileCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;

public class GetExportedProcessFileContentCmd
implements Command<String> {
    private Long modelId;
    private Log log = LogFactory.getLog(this.getClass());

    public GetExportedProcessFileContentCmd(Long modelId) {
        this.modelId = modelId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        this.log.debug(String.format("GetExportedProcessFileContent: %s", this.modelId));
        if (WfUtils.isEmpty(this.modelId)) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("modelid", "=", (Object)this.modelId)};
        List processDefinitions = commandContext.getProcessDefinitionEntityManager().findByQueryFilters(filters, "id", "id desc");
        if (processDefinitions.isEmpty()) {
            DeployFile deployFile = new GetDeployModelFileCmd(this.modelId).execute(commandContext);
            return deployFile.getFileContent();
        }
        DeployFile deployFile = new GetExportSchemeFileCmd(((ProcessDefinitionEntity)processDefinitions.get(0)).getId()).execute(commandContext);
        return deployFile.getFileContent();
    }
}

