/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.nocode.NoCodeFlowUtil;

public class GetFlowchartJsonCmd
implements Command<String> {
    private String businessKey;
    private Long procDefId;

    public GetFlowchartJsonCmd(String businessKey, Long procDefId) {
        this.businessKey = businessKey;
        this.procDefId = procDefId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        QFilter filter = new QFilter("businessKey", "=", (Object)this.businessKey);
        if (WfUtils.isNotEmpty(this.procDefId)) {
            filter.and(new QFilter("processDefinitionId", "=", (Object)this.procDefId));
        }
        String fields = String.format("%s,%s,%s", "id", "processDefinitionId", "schemeId");
        List procInsts = commandContext.getHistoricProcessInstanceEntityManager().findByQueryFilters(new QFilter[]{filter}, fields, "id desc");
        if (procInsts.isEmpty()) {
            return null;
        }
        HistoricProcessInstanceEntity procInst = (HistoricProcessInstanceEntity)procInsts.get(0);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(procInst.getProcessDefinitionId(), procInst.getSchemeId(), procInst.getId());
        if (bpmnModel == null) {
            return null;
        }
        String json = GraphCodecUtils.convertBpmnModelToJSON(bpmnModel);
        if (ModelType.NoCodeFlow.name().equals(bpmnModel.getMainProcess().getProcessType())) {
            JSONObject noCodeJson = NoCodeFlowUtil.convertWorkflowJsonToNoCodeJson(JSONObject.parseObject((String)json));
            json = noCodeJson.toJSONString();
        }
        return json;
    }
}

