/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.engine.history.HistoricTaskInstance;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.exception.WFObjectNotFoundException;

public class GetHistoricVariablesForTaskCmd
implements Command<List<HistoricVariableInstanceEntity>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Long taskId;

    public GetHistoricVariablesForTaskCmd(Long taskId) {
        if (taskId == null) {
            throw new WFIllegalArgumentException("taskId or processInstanceId is required");
        }
        this.taskId = taskId;
    }

    @Override
    public List<HistoricVariableInstanceEntity> execute(CommandContext commandContext) {
        if (this.taskId != null) {
            return this.getHistoricVariablesForTask(commandContext);
        }
        return new ArrayList<HistoricVariableInstanceEntity>();
    }

    protected List<HistoricVariableInstanceEntity> getHistoricVariablesForTask(CommandContext commandContext) {
        HistoricTaskInstanceEntity task = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(this.taskId);
        if (task == null) {
            throw new WFObjectNotFoundException("No historic task exists with the given id: " + this.taskId, HistoricTaskInstance.class);
        }
        return commandContext.getHistoricVariableInstanceEntityManager().findHistoricVariableInstancesByTaskId(this.taskId);
    }
}

