/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.task.IdentityLink;

public class GetIdentityLinksForTaskCmd
implements Command<List<IdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Long taskId;

    public GetIdentityLinksForTaskCmd(Long taskId) {
        this.taskId = taskId;
    }

    @Override
    public List<IdentityLink> execute(CommandContext commandContext) {
        IdentityLinkEntity identityLink;
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        List<IdentityLinkEntity> identityLinks = task.getIdentityLinks();
        Long userId = null;
        if (!WfUtils.isEmpty(task.getAssignee())) {
            identityLink = (IdentityLinkEntity)commandContext.getIdentityLinkEntityManager().create();
            userId = Long.parseLong(task.getAssignee());
            identityLink.setUserId(userId);
            identityLink.setUserName(WfUtils.findUserName(userId));
            identityLink.setType("assignee");
            identityLink.setTaskId(task.getId());
            identityLinks.add(identityLink);
        }
        if (!WfUtils.isEmpty(task.getOwner())) {
            identityLink = (IdentityLinkEntity)commandContext.getIdentityLinkEntityManager().create();
            userId = Long.parseLong(task.getOwner());
            identityLink.setUserId(userId);
            identityLink.setUserName(WfUtils.findUserName(userId));
            identityLink.setTaskId(task.getId());
            identityLink.setType("owner");
            identityLinks.add(identityLink);
        }
        return task.getIdentityLinks();
    }
}

