/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;

public class GetInProcessDataEntityCmd
implements Command<ExtendedDataEntity[]> {
    private ExtendedDataEntity[] dataEntities;

    public GetInProcessDataEntityCmd(ExtendedDataEntity[] dataEntities) {
        this.dataEntities = (ExtendedDataEntity[])dataEntities.clone();
    }

    @Override
    public ExtendedDataEntity[] execute(CommandContext commandContext) {
        ArrayList<String> noStartBusinesskey = new ArrayList<String>();
        ArrayList<Object> inProcessDataEntity = new ArrayList<Object>(1);
        HashMap<String, ExtendedDataEntity> businessKeyMapEnity = new HashMap<String, ExtendedDataEntity>();
        for (ExtendedDataEntity e : this.dataEntities) {
            if (e.getDataEntity().getPkValue() == null) continue;
            String businessKey = e.getDataEntity().getPkValue().toString();
            if (RuntimeUtil.isStarting(commandContext, businessKey)) {
                inProcessDataEntity.add(e);
                continue;
            }
            noStartBusinesskey.add(businessKey);
            businessKeyMapEnity.put(businessKey, e);
        }
        Set<String> runningBusinessKeys = RuntimeUtil.isRunning(commandContext, noStartBusinesskey);
        noStartBusinesskey.removeAll(runningBusinessKeys);
        Set<String> retryingBusinessKeys = RuntimeUtil.isRetring(commandContext, noStartBusinesskey);
        noStartBusinesskey.removeAll(retryingBusinessKeys);
        List<String> inProcessBusinessKeys = commandContext.getExecutionEntityManager().getInProcessBusinessKeys(noStartBusinesskey, String.format("%s,%s", "id", "businessKey"));
        inProcessBusinessKeys.addAll(retryingBusinessKeys);
        inProcessBusinessKeys.addAll(runningBusinessKeys);
        for (String businessKey : inProcessBusinessKeys) {
            inProcessDataEntity.add(businessKeyMapEnity.get(businessKey));
        }
        return inProcessDataEntity.toArray(new ExtendedDataEntity[inProcessDataEntity.size()]);
    }
}

