/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class GetLastAuditCountCmd
implements Command<Integer> {
    private Long processInstanceId;
    private String taskDefinitionKey;
    private String auditType;
    private String groupId;

    public GetLastAuditCountCmd(Long processInstanceId, String taskDefinitionKey, String auditType) {
        this.processInstanceId = processInstanceId;
        this.taskDefinitionKey = taskDefinitionKey;
        this.auditType = auditType;
    }

    public GetLastAuditCountCmd(Long processInstanceId, String taskDefinitionKey, String auditType, String groupId) {
        this(processInstanceId, taskDefinitionKey, auditType);
        this.groupId = groupId;
    }

    @Override
    public Integer execute(CommandContext commandContext) {
        int count = 0;
        StringBuilder sql = new StringBuilder("SELECT count(DISTINCT FUSERID) FROM t_wf_hicomment WHERE FPROCINSTID = ? AND FACTIVITYID = ? AND FUSERID != 0 ");
        ArrayList<Object> paramsList = new ArrayList<Object>();
        paramsList.add(this.processInstanceId);
        paramsList.add(this.taskDefinitionKey);
        if (WfUtils.isNotEmpty(this.auditType)) {
            sql.append("AND FDECISIONTYPE = ? ");
            paramsList.add(this.auditType);
        } else {
            sql.append("AND FDECISIONTYPE in ('approve','reject')");
        }
        if (WfUtils.isNotEmpty(this.groupId)) {
            sql.append("AND FGROUPID = ? ");
            paramsList.add(this.groupId);
        }
        try (DataSet ds = DB.queryDataSet((String)"GetLastAuditCountCmd.t_wf_hicomment.execute", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])paramsList.toArray(new Object[paramsList.size()]));){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row r = (Row)iter.next();
                count = r.getInteger(0);
            }
        }
        return count;
    }
}

