/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.AuditInfo;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;

public class GetLastAuditInfoCmd
implements Command<AuditInfo> {
    private Long processInstanceId;
    private String taskDefinitionKey;
    private String auditType;
    private Long participantId;

    public GetLastAuditInfoCmd(Long processInstanceId, String taskDefinitionKey, String auditType, Long participantId) {
        this.processInstanceId = processInstanceId;
        this.taskDefinitionKey = taskDefinitionKey;
        this.auditType = auditType;
        this.participantId = participantId;
    }

    @Override
    public AuditInfo execute(CommandContext commandContext) {
        AuditInfo auditInfo = null;
        ILocaleString auditMsg = null;
        boolean isAutoAudit = false;
        String auditNumber = null;
        QFilter[] qFilters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)this.processInstanceId), new QFilter("activityId", "=", (Object)this.taskDefinitionKey), new QFilter("decisionType", "=", (Object)this.auditType), new QFilter("userId", "=", (Object)this.participantId)};
        List comments = commandContext.getCommentEntityManager().findByQueryFilters(qFilters, "message,resultNumber", "time DESC ");
        Boolean isSensitivefieldChange = this.checkSensitiveFieldChange(commandContext);
        if (WfUtils.isNotEmptyForCollection(comments) && !isSensitivefieldChange.booleanValue()) {
            isAutoAudit = true;
            CommentEntity comment = (CommentEntity)comments.get(0);
            auditMsg = comment.getCommentMessage();
            auditNumber = comment.getResultNumber();
        }
        auditInfo = new AuditInfo(true, auditMsg);
        auditInfo.setAutoAudit(isAutoAudit);
        auditInfo.setAuditNumber(auditNumber);
        return auditInfo;
    }

    private Boolean checkSensitiveFieldChange(CommandContext commandContext) {
        Boolean isSensitivefieldChange = Boolean.FALSE;
        List commentEntities = commandContext.getCommentEntityManager().findByQueryFilters(new QFilter[]{new QFilter("processInstanceId", "=", (Object)this.processInstanceId)}, "activityId, sensitivefieldchange", "step DESC ");
        if (CollectionUtil.isNotEmpty(commentEntities)) {
            for (CommentEntity commentEntity : commentEntities) {
                ILocaleString sensitivefieldchange = commentEntity.getSensitivefieldchange();
                isSensitivefieldChange = WfUtils.isNotEmpty(sensitivefieldchange);
                if (!this.taskDefinitionKey.equals(commentEntity.getActivityId()) && !isSensitivefieldChange.booleanValue()) continue;
                break;
            }
        }
        return isSensitivefieldChange;
    }
}

