/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class GetLastAuditParticipantsCmd
implements Command<List<Long>> {
    private Long processInstanceId;
    private String taskDefinitionKey;
    private String auditType;
    private String groupId;

    public GetLastAuditParticipantsCmd(Long processInstanceId, String taskDefinitionKey, String auditType) {
        this.processInstanceId = processInstanceId;
        this.taskDefinitionKey = taskDefinitionKey;
        this.auditType = auditType;
    }

    public GetLastAuditParticipantsCmd(Long processInstanceId, String taskDefinitionKey, String auditType, String groupId) {
        this(processInstanceId, taskDefinitionKey, auditType);
        this.groupId = groupId;
    }

    @Override
    public List<Long> execute(CommandContext commandContext) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        StringBuilder sql = new StringBuilder("SELECT DISTINCT FUSERID FROM t_wf_hicomment WHERE FPROCINSTID = ? AND FACTIVITYID = ? AND FUSERID != 0 ");
        ArrayList<Object> paramsList = new ArrayList<Object>();
        paramsList.add(this.processInstanceId);
        paramsList.add(this.taskDefinitionKey);
        if (WfUtils.isNotEmpty(this.auditType)) {
            sql.append("AND FDECISIONTYPE = ? ");
            paramsList.add(this.auditType);
        } else {
            sql.append("AND FDECISIONTYPE in ('approve','reject')");
        }
        if (WfUtils.isNotEmpty(this.groupId)) {
            sql.append("AND FGROUPID = ? ");
            paramsList.add(this.groupId);
        }
        try (DataSet ds = DB.queryDataSet((String)"GetLastAuditCountCmd.t_wf_hicomment.execute", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])paramsList.toArray(new Object[paramsList.size()]));){
            if (null == ds) {
                ArrayList<Long> arrayList = userIds;
                return arrayList;
            }
            Iterator iter = ds.iterator();
            if (null == iter) {
                ArrayList<Long> arrayList = userIds;
                return arrayList;
            }
            Row r = null;
            Long userId = null;
            while (iter.hasNext()) {
                r = (Row)iter.next();
                if (null == r || !WfUtils.isNotEmpty(userId = r.getLong(0))) continue;
                userIds.add(userId);
            }
        }
        return userIds;
    }
}

