/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.calculator.ExpressionParseResult;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;

public class GetMsgTemplateValuesCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = -507224618120671233L;
    private String expression;
    private DynamicObject dynamicObject;
    private transient VariableScope scope;
    private transient Map<String, Object> param;
    private boolean userFormat;
    private String businessKey;
    private String entityNumber;
    private static final String MESSAGESENDERID = "messageSenderId";
    private static final String LANG = "lang";
    private static final String PARSESUBJECT = "parsesubject";
    private static final String GLANG = "GLang";

    public GetMsgTemplateValuesCmd(String expression, DynamicObject dynamicObject, VariableScope scope, Map<String, Object> param) {
        this.expression = expression;
        this.dynamicObject = dynamicObject;
        this.scope = scope;
        this.param = param;
        this.userFormat = true;
    }

    public GetMsgTemplateValuesCmd(String businessKey, String entityNumber, String expression, VariableScope scope) {
        this.businessKey = businessKey;
        this.entityNumber = entityNumber;
        this.expression = expression;
        this.scope = scope;
    }

    @Override
    public String execute(CommandContext commandContext) {
        this.scope.setTransientVariable("isfrommsg", Boolean.TRUE);
        if (this.dynamicObject == null) {
            this.dynamicObject = WfUtils.findBusinessObject(this.businessKey, this.entityNumber);
            ExpressionParseResult expressionParseResult = ExpressionCalculatorUtil.msgContentParser(this.expression, this.dynamicObject, this.scope, this.param, true);
            return expressionParseResult.getParsedContent();
        }
        this.addSubjectParam(commandContext);
        ExpressionParseResult expressionParseResult = ExpressionCalculatorUtil.msgContentParser(this.expression, this.dynamicObject, this.scope, this.param, this.userFormat);
        return expressionParseResult.getParsedContent();
    }

    private void addSubjectParam(CommandContext commandContext) {
        if (this.param == null || StringUtils.isNotBlank((Object)this.param.get(PARSESUBJECT))) {
            return;
        }
        if (!(this.scope instanceof TaskEntityImpl) && !(this.scope instanceof HistoricIdentityLinkEntityImpl)) {
            return;
        }
        Long id = ((Entity)this.scope).getId();
        Long snederId = this.param.get(MESSAGESENDERID) != null ? (Long)this.param.get(MESSAGESENDERID) : null;
        List<HistoricIdentityLinkEntity> hisLinkEntity = commandContext.getHistoricIdentityLinkEntityManager().findHistoricIdentityLinksByTaskIdUserId(id, snederId);
        if (hisLinkEntity != null && !hisLinkEntity.isEmpty() && WfUtils.isNotEmpty(hisLinkEntity.get(0).getCurrenSubject())) {
            ILocaleString currenSubject = hisLinkEntity.get(0).getCurrenSubject();
            String lang = this.param.get(LANG) != null ? (String)this.param.get(LANG) : RequestContext.get().getLang().toString();
            String subject = currenSubject.getItem(lang) != null ? (String)currenSubject.getItem(lang) : (String)currenSubject.getItem(GLANG);
            this.param.put(PARSESUBJECT, subject);
        }
    }
}

