/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.model.MacroItem;
import kd.bos.workflow.api.model.NodeMacro;
import kd.bos.workflow.bpmn.model.AutoMicroServiceTask;
import kd.bos.workflow.bpmn.model.BillCloseConfig;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EventParam;
import kd.bos.workflow.bpmn.model.EventSupportTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Macro;
import kd.bos.workflow.bpmn.model.Parameter;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.GetResourceByModelIdAndTypeCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.nocode.NoCodeFlowUtil;

public class GetNodeMacrosCmd
implements Command<List<NodeMacro>> {
    private Long modelId;
    private String modelJson;
    private String macroType;
    private String procType;
    private String nodeJson;
    private Log log = LogFactory.getLog(this.getClass());

    public GetNodeMacrosCmd(Long modelId, String macroType) {
        this.modelId = modelId;
        this.macroType = macroType;
    }

    public GetNodeMacrosCmd(String modelJson, String macroType) {
        this.modelJson = modelJson;
        this.macroType = macroType;
    }

    public GetNodeMacrosCmd(String procType, String nodeJson, String macroType) {
        this.procType = procType;
        this.nodeJson = nodeJson;
        this.macroType = macroType;
    }

    @Override
    public List<NodeMacro> execute(CommandContext commandContext) {
        JSONObject data;
        this.log.debug(String.format("macroType: %s, modelId: %s, procType: %s, nodeJson: %s, modelJson: %s", this.macroType, this.modelId, this.procType, WfUtils.isEmpty(this.nodeJson), WfUtils.isEmpty(this.modelJson)));
        ArrayList<NodeMacro> nodeMacros = new ArrayList<NodeMacro>(32);
        if (WfUtils.isNotEmpty(this.modelJson)) {
            data = JSON.parseObject((String)this.modelJson);
            if ("NoCodeWfMetaData".equals(data.getString("_Type_"))) {
                this.modelJson = NoCodeFlowUtil.convertNoCodeJsonToWorkflowJson(data).toJSONString();
            }
        } else if (WfUtils.isNotEmpty(this.procType) && WfUtils.isNotEmpty(this.nodeJson)) {
            data = this.getModelJsonByProcTypeAndNodeJson();
            this.modelJson = data.toJSONString();
        } else if (WfUtils.isNotEmpty(this.modelId)) {
            ResourceEntity resource = new GetResourceByModelIdAndTypeCmd(this.modelId, "graph_json").execute(commandContext);
            this.modelJson = resource.getData();
        } else {
            this.log.debug("The parameters are incorrect.");
            return new ArrayList<NodeMacro>();
        }
        BpmnModel model = ProcessDefinitionUtil.getBpmnModel(this.modelJson);
        Process process = model.getMainProcess();
        List<Macro> macros = process.getMacros();
        block8: for (Macro macro : macros) {
            String macroNumber = macro.getName();
            if (!macroNumber.endsWith(this.macroType)) continue;
            switch (this.macroType) {
                case "ExecuteResult": {
                    nodeMacros.add(this.getNodeExecuteResultMacro(macro, process));
                    continue block8;
                }
                case "EventParams": {
                    nodeMacros.add(this.getNodeEventParamsMacro(macro, process));
                    continue block8;
                }
            }
            nodeMacros.add(this.getNodeMacro(macro, process));
        }
        return nodeMacros;
    }

    private JSONObject getModelJsonByProcTypeAndNodeJson() {
        JSONObject data = new JSONObject();
        JSONArray childShapes = new JSONArray();
        data.put("childShapes", (Object)childShapes);
        Object param = JSON.parse((String)this.nodeJson);
        if (param instanceof JSONObject) {
            JSONObject child = (JSONObject)param;
            childShapes.add((Object)child);
        } else if (param instanceof JSONArray) {
            JSONArray children = (JSONArray)param;
            childShapes.addAll((Collection)children);
        } else {
            this.log.debug(String.format("unexpected nodeJson type: %s", param != null ? param.getClass() : null));
            return data;
        }
        if (ModelType.NoCodeFlow.name().equals(this.procType)) {
            data.put("_Type_", (Object)"NoCodeWfMetaData");
            data.put("nodes", (Object)childShapes);
            return NoCodeFlowUtil.convertNoCodeJsonToWorkflowJson(data);
        }
        data.put("resourceId", (Object)"node_1");
        JSONObject location = new JSONObject();
        location.put("x", (Object)0);
        location.put("y", (Object)0);
        JSONObject bounds = new JSONObject();
        bounds.put("upperLeft", (Object)location);
        bounds.put("lowerRight", (Object)location);
        JSONObject properties = new JSONObject();
        properties.put("processType", (Object)this.procType);
        data.put("properties", (Object)properties);
        return data;
    }

    private NodeMacro getNodeExecuteResultMacro(Macro macro, Process process) {
        AutoMicroServiceTask task;
        List<Parameter> outParams;
        NodeMacro nodeMacro = this.getNodeMacro(macro, process);
        String nodeId = nodeMacro.getNodeId();
        FlowElement element = process.getFlowElement(nodeId);
        if (element instanceof AutoMicroServiceTask && (outParams = (task = (AutoMicroServiceTask)element).getOutParams()) != null && !outParams.isEmpty()) {
            for (Parameter param : outParams) {
                MacroItem item = new MacroItem();
                item.setDataType(param.getType());
                item.setName(param.getName());
                item.setNumber(param.getNumber());
                nodeMacro.getItems().add(item);
            }
        }
        return nodeMacro;
    }

    private NodeMacro getNodeEventParamsMacro(Macro macro, Process process) {
        BillTask billTask;
        BillCloseConfig config;
        NodeMacro nodeMacro = this.getNodeMacro(macro, process);
        String nodeId = nodeMacro.getNodeId();
        List<EventParam> evtParams = null;
        FlowElement element = process.getFlowElement(nodeId);
        if (element instanceof EventSupportTask) {
            EventSupportTask task = (EventSupportTask)element;
            evtParams = task.getEventParams();
        } else if (element instanceof BillTask && (config = (billTask = (BillTask)element).getBillCloseConfig()) != null && config.getWaitActions() != null && config.getWaitActions().getCloseEvent() != null) {
            evtParams = config.getWaitActions().getCloseEvent().getParams();
        }
        if (evtParams != null && !evtParams.isEmpty()) {
            for (EventParam param : evtParams) {
                MacroItem item = new MacroItem();
                item.setName(param.getName());
                item.setNumber(param.getNumber());
                nodeMacro.getItems().add(item);
            }
        }
        return nodeMacro;
    }

    private NodeMacro getNodeMacro(Macro macro, Process process) {
        NodeMacro nodeMacro = new NodeMacro();
        String macroNumber = macro.getName();
        String nodeId = macroNumber.replace(this.macroType, "");
        nodeMacro.setNodeId(nodeId);
        nodeMacro.setNumber(macroNumber);
        nodeMacro.setName(macro.getDescription());
        return nodeMacro;
    }
}

