/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityManager;

public class GetNotWithdrawProcInstIdByBusKeyCmd
implements Command<Long>,
Serializable {
    protected static Log logger = LogFactory.getLog(GetNotWithdrawProcInstIdByBusKeyCmd.class);
    private static final long serialVersionUID = 1806631867229118272L;
    private String businessKey;

    public GetNotWithdrawProcInstIdByBusKeyCmd(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public Long execute(CommandContext commandContext) {
        HistoricProcessInstanceEntityManager historicProcessInstanceEntityManager = commandContext.getHistoricProcessInstanceEntityManager();
        EntityQueryBuilder eb = historicProcessInstanceEntityManager.createQueryBuilder().addFilter("businessKey", this.businessKey).addFilter("endTime", "is null", null).addFilter("deleteReason", "!=", "process instance withdraw").orderBy("modifyDate desc ");
        List result = historicProcessInstanceEntityManager.findByQueryBuilder(eb);
        Long bizInstanceId = null;
        Long procinstId = null;
        for (HistoricProcessInstanceEntity h : result) {
            if (ProcessType.BizFlow.name().equals(h.getProcessType())) {
                bizInstanceId = h.getProcessInstanceId();
                break;
            }
            if (WfUtils.isNotEmpty(h.getSuperProcessInstanceId())) {
                if (!ProcessType.BizFlow.name().equals(((HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(h.getSuperProcessInstanceId())).getProcessType())) continue;
                procinstId = h.getId();
                break;
            }
            if (h.getId().equals(procinstId)) {
                logger.debug(String.format("businesskey[%s] hiprocess is error, has more instance", this.businessKey));
            }
            procinstId = h.getId();
        }
        if (procinstId != null && WfUtils.isNotEmpty(bizInstanceId)) {
            for (HistoricProcessInstanceEntity h : result) {
                if (!h.getSuperProcessInstanceId().equals(bizInstanceId)) continue;
                procinstId = h.getId();
                break;
            }
        }
        return procinstId;
    }
}

