/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.ParticipantRangeUtil;
import kd.bos.workflow.engine.impl.cmd.GetUserIdsByCalculateCmd;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;

public class GetParticipantByInstanceFirstCmd
implements Command<List<Long>> {
    private String taskId;
    private String selectTaskNum;
    private String businessKey;
    private String formNum;
    private Long processDefinitionId;
    private Long processInstanceId;
    private String dataEntity;

    public GetParticipantByInstanceFirstCmd(String taskId, String selectTaskNum, String businessKey, String formNum, Long processDefinitionId, Long processInstanceId, String dataEntity) {
        this.taskId = taskId;
        this.selectTaskNum = selectTaskNum;
        this.businessKey = businessKey;
        this.formNum = formNum;
        this.processDefinitionId = processDefinitionId;
        this.processInstanceId = processInstanceId;
        this.dataEntity = dataEntity;
    }

    @Override
    public List<Long> execute(CommandContext commandContext) {
        TaskEntity taskEntity;
        String executionVariable;
        List<Long> participantInfo = new ArrayList<Long>();
        if (this.processInstanceId != null && this.taskId != null && WfUtils.isNotEmpty(executionVariable = (String)(taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(Long.valueOf(this.taskId))).getExecution().getProcessInstance().getVariable("dynParticipant"))) {
            List instanceParticipantList = SerializationUtils.fromJsonStringToList((String)executionVariable, Map.class);
            for (Map instanceParticipant : instanceParticipantList) {
                String nodeId = (String)instanceParticipant.get("nodeId");
                if (!this.selectTaskNum.equals(nodeId)) continue;
                String userInfo = (String)instanceParticipant.get("userIds");
                String[] userArray = userInfo.split(",");
                List<String> participantList = Arrays.asList(userArray);
                participantInfo = this.changeListType(participantList);
                return participantInfo;
            }
        }
        if (participantInfo.size() == 0) {
            DynamicObject dynamicObject = null;
            UserTask userElement = null;
            if (this.processInstanceId == null) {
                dynamicObject = DynamicObjectJsonSerializer.parseDynamicObjectJson(this.dataEntity, this.formNum);
                RepositoryService repositoryService = WfUtils.getWfService().getRepositoryService();
                BusinessModelVariableScope variableScope = new BusinessModelVariableScope(dynamicObject);
                BpmnModel bpmnModel = repositoryService.getBpmnModelForScheme(this.processDefinitionId, variableScope);
                FlowElement flowElement = bpmnModel.getFlowElement(this.selectTaskNum);
                userElement = (UserTask)flowElement;
            } else {
                dynamicObject = BusinessDataServiceHelper.loadSingle((Object)this.businessKey, (String)this.formNum);
                userElement = ParticipantRangeUtil.getFlowElement(this.processDefinitionId, this.processInstanceId, this.selectTaskNum, null);
            }
            if (userElement != null) {
                ParticipatantModel participatantModel = userElement.getParticipant();
                List<ParticipantModelEntityImpl> defaultParticipantList = participatantModel.getParticipant();
                BusinessModelVariableScope businessModelVariableScope = new BusinessModelVariableScope(dynamicObject);
                GetUserIdsByCalculateCmd GetUserIdsByCalculateCmd2 = new GetUserIdsByCalculateCmd(this.businessKey, businessModelVariableScope, defaultParticipantList);
                participantInfo = GetUserIdsByCalculateCmd2.execute(commandContext);
            }
        }
        return participantInfo;
    }

    public List<Long> changeListType(List<String> participantList) {
        ArrayList<Long> participantInfo = new ArrayList<Long>(participantList.size());
        for (String participant : participantList) {
            if (!WfUtils.isNotEmpty(participant)) continue;
            participantInfo.add(Long.valueOf(participant));
        }
        return participantInfo;
    }
}

