/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class GetParticipantSettingCommentsByProcInstId
implements Command<List<CommentEntity>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Long procInstId;
    protected String fields = "id,type,userId,taskId,processInstanceId,activityId,message,resultNumber,resultName,time,assignee,decisionType,groupId,backToBack,usernameformatter,ownerid,assignorname";
    protected String sort = "id asc";
    private Boolean isDisplaySetting = null;

    public GetParticipantSettingCommentsByProcInstId(Long procInstId, String fields, String sort) {
        this.procInstId = procInstId;
        if (WfUtils.isNotEmpty(fields)) {
            this.fields = fields;
        }
        if (WfUtils.isNotEmpty(sort)) {
            this.sort = sort;
        }
        if (procInstId == null) {
            throw new WFIllegalArgumentException("procInstId is null");
        }
    }

    @Override
    public List<CommentEntity> execute(CommandContext commandContext) {
        QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)this.procInstId), new QFilter("type", "=", (Object)"comment")};
        List<CommentEntity> commentEntityList = commandContext.getCommentEntityManager().findApprovalRecordByAuth(filters, this.sort, true);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(this.procInstId);
        Process process = bpmnModel.getMainProcess();
        HashMap<CommentEntity, FlowElement> commentEleMap = new HashMap<CommentEntity, FlowElement>(commentEntityList.size());
        ArrayList<Long> taskIds = new ArrayList<Long>(commentEntityList.size());
        for (CommentEntity commentEntity : commentEntityList) {
            FlowElement element = process.getFlowElement(commentEntity.getActivityId());
            if (!(element instanceof UserTask)) continue;
            commentEleMap.put(commentEntity, element);
            Long taskId = commentEntity.getTaskId();
            taskIds.add(taskId);
        }
        List<HistoricIdentityLinkEntity> hiParticipants = commandContext.getHistoricIdentityLinkEntityManager().findParticipantsByTaskIds(this.procInstId, taskIds);
        for (CommentEntity commentEntity : commentEntityList) {
            if (commentEleMap.get(commentEntity) == null) continue;
            FlowElement element = (FlowElement)commentEleMap.get(commentEntity);
            Long ownerId = commentEntity.getOwnerId();
            ILocaleString assignee = commentEntity.getUserNameFormatter();
            ILocaleString userNameFormatter = this.getUserNameFormatter(commentEntity, hiParticipants);
            ILocaleString assignorName = ParticipantHelper.getUserName(commentEntity.getAssignorName(), userNameFormatter);
            String displayInfo = null;
            UserTask userTask = (UserTask)element;
            if (userTask.getParticipant() != null) {
                displayInfo = userTask.getParticipant().getDisplayInfo();
            }
            if (!this.isDisplaySetting() && WfUtils.isEmpty(displayInfo)) {
                assignee = commentEntity.getTaskAssignee();
                assignorName = commentEntity.getAssignorName();
            }
            if (WfUtils.isEmpty(ownerId) || WfUtils.isEmpty(assignorName) || WfUtils.isEmpty(assignee)) continue;
            String delegateAssigneeName = TaskDelegateUtil.getDelegateAssigneeName(assignorName.toString(), assignee.toString(), "replace");
            commentEntity.setUserNameFormatter((ILocaleString)new LocaleString(delegateAssigneeName));
        }
        return commentEntityList;
    }

    protected boolean isDisplaySetting() {
        if (this.isDisplaySetting == null) {
            this.isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        }
        return this.isDisplaySetting;
    }

    private ILocaleString getUserNameFormatter(CommentEntity commentEntity, List<HistoricIdentityLinkEntity> hiParticipants) {
        LocaleString userNameFormatter = new LocaleString();
        Long taskId = commentEntity.getTaskId();
        Long ownerId = commentEntity.getOwnerId();
        if (WfUtils.isNotEmptyForCollection(hiParticipants)) {
            for (HistoricIdentityLinkEntity entity : hiParticipants) {
                if (taskId == null || ownerId == null || !taskId.equals(entity.getTaskId()) || !ownerId.equals(entity.getUserId())) continue;
                return entity.getUserNameFormatter();
            }
        }
        return userNameFormatter;
    }
}

