/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import kd.bos.workflow.engine.history.HistoricProcessInstance;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class GetProcInstIdByBusinessKeyAndEntityNumberCmd
implements Command<Long>,
Serializable {
    private static final long serialVersionUID = 3775422900790134092L;
    private String businessKey;
    private String entityNumber;

    public GetProcInstIdByBusinessKeyAndEntityNumberCmd(String businessKey, String entityNumber) {
        this.businessKey = businessKey;
        this.entityNumber = entityNumber;
    }

    @Override
    public Long execute(CommandContext commandContext) {
        if (this.businessKey == null) {
            throw new WFIllegalArgumentException("businessKey is null");
        }
        if (this.entityNumber == null) {
            throw new WFIllegalArgumentException("entityNumber is null");
        }
        List executionEntities = commandContext.getExecutionEntityManager().findByQueryBuilder(commandContext.getExecutionEntityManager().createQueryBuilder().addFilter("businessKey", this.businessKey).addFilter("entityNumber", this.entityNumber).addFilter("processType", ModelType.AuditFlow.name()).orderBy("createDate desc"));
        if (executionEntities != null && executionEntities.size() > 0) {
            return ((ExecutionEntity)executionEntities.get(0)).getProcessInstanceId();
        }
        HistoricProcessInstance hiProcInst = commandContext.getHistoricProcessInstanceEntityManager().findLatestAuditHiprocinstByBusinessKeyAndEntityNumber(this.businessKey, this.entityNumber);
        if (hiProcInst != null) {
            HistoricProcessInstanceEntityImpl impl = (HistoricProcessInstanceEntityImpl)hiProcInst;
            return impl.getProcessInstanceId();
        }
        return null;
    }
}

