/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import kd.bos.workflow.engine.history.HistoricProcessInstance;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class GetProcInstIdByBusinessKeyCMD
implements Command<Long>,
Serializable {
    private static final long serialVersionUID = 1806631867229118272L;
    private String businessKey;

    public GetProcInstIdByBusinessKeyCMD(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public Long execute(CommandContext commandContext) {
        if (this.businessKey == null) {
            throw new WFIllegalArgumentException("businessKey is null");
        }
        List executionEntities = commandContext.getExecutionEntityManager().findByQueryBuilder(commandContext.getExecutionEntityManager().createQueryBuilder().addFilter("businessKey", this.businessKey).orderBy("createDate desc"));
        if (executionEntities != null && executionEntities.size() > 0) {
            return ((ExecutionEntity)executionEntities.get(0)).getProcessInstanceId();
        }
        HistoricProcessInstance hiProcInst = commandContext.getHistoricProcessInstanceEntityManager().findLatestHistoricProcessInstanceByBusinessKey(this.businessKey);
        if (hiProcInst != null) {
            HistoricProcessInstanceEntityImpl impl = (HistoricProcessInstanceEntityImpl)hiProcInst;
            return impl.getProcessInstanceId();
        }
        return null;
    }
}

