/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.engine.history.HistoricProcessInstance;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class GetProcInstPropertiesByBusinessKeyCmd
implements Command<Map<String, Object>>,
Serializable {
    private static final long serialVersionUID = 1806631867229118272L;
    private String businessKey;

    public GetProcInstPropertiesByBusinessKeyCmd(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        if (this.businessKey == null) {
            throw new WFIllegalArgumentException("businessKey is null");
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(13);
        List executionEntities = commandContext.getExecutionEntityManager().findByQueryBuilder(commandContext.getExecutionEntityManager().createQueryBuilder().addFilter("businessKey", this.businessKey).addFilter("scope", Character.valueOf('1')));
        if (executionEntities != null && executionEntities.size() > 0) {
            ExecutionEntity executionEntity = (ExecutionEntity)executionEntities.get(0);
            resultMap.put("processInstanceId", executionEntity.getProcessInstanceId());
            resultMap.put("subject", executionEntity.getSubject() == null ? "" : executionEntity.getSubject());
            resultMap.put("startUserId", executionEntity.getStartUserId());
            resultMap.put("billno", executionEntity.getBillNo());
            resultMap.put("name", executionEntity.getName() == null ? "" : executionEntity.getName());
            resultMap.put("suspensionState", executionEntity.getSuspensionState());
            resultMap.put("suspensionStateName", "1".equalsIgnoreCase(executionEntity.getSuspensionState()) ? ResManager.loadKDString((String)"\u6b63\u5e38", (String)"GetProcInstPropertiesByBusinessKeyCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6302\u8d77", (String)"GetProcInstPropertiesByBusinessKeyCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
            resultMap.put("activityName", executionEntity.getActivityName());
            resultMap.put("entityNumber", executionEntity.getEntityNumber());
            resultMap.put("businessKey", executionEntity.getBusinessKey());
            resultMap.put("createDate", executionEntity.getCreateDate());
            resultMap.put("endTime", null);
            resultMap.put("duration", 0L);
            return resultMap;
        }
        HistoricProcessInstance hiProcInst = commandContext.getHistoricProcessInstanceEntityManager().findLatestHistoricProcessInstanceByBusinessKey(this.businessKey);
        if (hiProcInst != null) {
            HistoricProcessInstanceEntityImpl impl = (HistoricProcessInstanceEntityImpl)hiProcInst;
            resultMap.put("processInstanceId", impl.getProcessInstanceId());
            resultMap.put("subject", impl.getSubject() == null ? "" : impl.getSubject());
            resultMap.put("startUserId", impl.getStartUserId());
            resultMap.put("billno", impl.getBillNo());
            resultMap.put("name", impl.getName() == null ? "" : impl.getName());
            resultMap.put("suspensionState", impl.getEndTime() == null ? "" : Integer.valueOf(3));
            resultMap.put("suspensionStateName", impl.getEndTime() == null ? null : ResManager.loadKDString((String)"\u7ed3\u675f", (String)"GetProcInstPropertiesByBusinessKeyCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
            resultMap.put("createDate", impl.getCreateDate());
            resultMap.put("activityName", impl.getActivityName());
            resultMap.put("entityNumber", impl.getEntitynumber());
            resultMap.put("businessKey", impl.getBusinessKey());
            resultMap.put("endTime", impl.getEndTime());
            resultMap.put("duration", impl.getDurationInMillis());
            return resultMap;
        }
        return null;
    }
}

