/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.HashTable;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class GetProcessDefinitionDataCmd
implements Command<DynamicObjectCollection>,
Serializable {
    private static final long serialVersionUID = -2827671076671133003L;
    private int start;
    private int limit;
    private List<QFilter> qFilters;
    private String orderBy;

    public GetProcessDefinitionDataCmd(int start, int limit, List<QFilter> qFilters, String orderBy) {
        this.start = start;
        this.limit = limit;
        this.qFilters = qFilters;
        this.orderBy = orderBy;
    }

    @Override
    public DynamicObjectCollection execute(CommandContext commandContext) {
        DynamicObjectCollection ret = null;
        String fields = "id,key,businessid,name,type,primarysubprocess,entrabillid.name entrabillname,orgunitid.name orgunitname,versionstate,version,description,enable,publishname,createdate,versiondesc";
        ORM orm = ORM.create();
        String[] order = this.orderBy == null || this.orderBy.equals("") ? new String[]{"createdate desc"} : this.orderBy.split(",");
        List<String> types = Arrays.asList(ConditionalRuleType.processStartUp.toString(), ConditionalRuleType.bpmProcStartUp.toString(), ConditionalRuleType.eventStartUp.toString());
        try (DataSet pdDS = orm.queryDataSet(this.createAlgoKey(), "wf_processdefinition", fields, this.qFilters == null ? null : this.qFilters.toArray(new QFilter[0])).orderBy(order);){
            String sql = "procdefid, showtext startcondition";
            QFilter q = new QFilter("type", "in", types);
            HashTable conditionalRuleTable = orm.queryDataSet(this.createAlgoKey(), "wf_conditionalrule", sql, new QFilter[]{q}).toHashTable("procdefid");
            try (DataSet ds = pdDS.hashJoin(conditionalRuleTable, "id", new String[]{"startcondition"}, true).selectLeftFields(new String[]{"id", "key", "businessid", "name", "type", "primarysubprocess", "entrabillname", "orgunitname", "versionstate", "version", "description", "enable", "publishname", "createdate", "versiondesc"}).finish();){
                ret = ORM.create().toPlainDynamicObjectCollection(ds, this.start, this.limit);
            }
            DynamicObjectCollection dynamicObjectCollection = ret;
            return dynamicObjectCollection;
        }
    }

    protected String createAlgoKey() {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        return new StringBuffer().append("bos.wf.").append(this.getClass().getName()).append(".").append(methodName).toString();
    }
}

